/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SpringUtil
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static ThreadLocal<HttpServletRequest> requestThreadLocal;

    public static HttpServletRequest getRequest() {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            return request;
        }
        catch (Exception e) {
            return requestThreadLocal.get();
        }
    }

    public static void setRequest(HttpServletRequest request) {
        requestThreadLocal.set(request);
    }

    @Deprecated
    public static Object getBean(ServletContext sc, String beanName) {
        return SpringUtil.getApplicationContext().getBean(beanName);
    }

    public static Object getBean(String beanName) {
        return SpringUtil.getApplicationContext().getBean(beanName);
    }

    public static <T> T getBean(Class<T> cls) {
        return (T)SpringUtil.getApplicationContext().getBean(cls);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpringUtil.applicationContext == null) {
            SpringUtil.applicationContext = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    static {
        requestThreadLocal = new ThreadLocal();
    }
}

