/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import io.swagger.annotations.Api;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.mingsoft.base.constant.e.BaseEnum;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.constant.Const;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Api(value="\u57fa\u7840\u5e94\u7528\u5c42\u7684\u7236\u7c7bbase")
public abstract class BaseAction
extends net.mingsoft.base.action.BaseAction {
    @Autowired
    private IAppBiz appBiz;

    protected ModelEntity getCategoryModelCode() {
        Object obj = BasicUtil.getSession(SessionConstEnum.MODEL_ID_SESSION);
        if (NumberUtils.isCreatable((String)obj.toString())) {
            IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
            return modelBiz.getModel("99", Integer.parseInt(obj.toString()));
        }
        return null;
    }

    protected ModelEntity getBasicModelCode() {
        Object obj = BasicUtil.getSession(SessionConstEnum.MODEL_ID_SESSION);
        if (NumberUtils.isNumber((String)obj.toString())) {
            IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
            return modelBiz.getModel("98", Integer.parseInt(obj.toString()));
        }
        return null;
    }

    protected int getManagerId() {
        ManagerSessionEntity managerSession = this.getManagerBySession();
        int managerParent = managerSession.getManagerParentID();
        if (managerParent == 0) {
            return managerSession.getManagerId();
        }
        return managerParent;
    }

    protected boolean isSystemManager() {
        ManagerSessionEntity manager = this.getManagerBySession();
        return manager.getManagerRoleID() == 1;
    }

    protected ManagerSessionEntity getManagerBySession() {
        ManagerSessionEntity managerSession = (ManagerSessionEntity)((Object)BasicUtil.getSession(SessionConstEnum.MANAGER_SESSION));
        if (managerSession != null) {
            return managerSession;
        }
        return null;
    }

    protected String getResString(String key) {
        return Const.RESOURCES.getString(key);
    }

    protected boolean checkRandCode() {
        return this.checkRandCode(SessionConstEnum.CODE_SESSION.toString());
    }

    protected String decryptByAES(HttpServletRequest request, String str) {
        String _str = SecureUtil.aes((byte[])SecureUtil.md5((String)(this.getApp(request).getAppId() + "")).substring(16).getBytes()).decryptStr(str);
        return _str;
    }

    protected String encryptByAES(HttpServletRequest request, String str) {
        String _str = SecureUtil.aes((byte[])SecureUtil.md5((String)(this.getApp(request).getAppId() + "")).substring(16).getBytes()).encryptHex(str);
        return _str;
    }

    protected int getHistoryPageNoByCookie() {
        if (Integer.valueOf(BasicUtil.getCookie(CookieConstEnum.PAGENO_COOKIE)) >= 1) {
            return Integer.valueOf(BasicUtil.getCookie(CookieConstEnum.PAGENO_COOKIE));
        }
        return 0;
    }

    @Deprecated
    protected int getAppId(HttpServletRequest request) {
        return this.getApp(request).getAppId();
    }

    @Deprecated
    protected AppEntity getApp(HttpServletRequest request) {
        AppEntity app = new AppEntity();
        AppEntity website = this.appBiz.getByUrl(this.getDomain(request));
        if (website == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)((Object)website), (Object)((Object)app));
        return app;
    }

    protected String getRandCode() {
        return BasicUtil.getSession(SessionConstEnum.CODE_SESSION) + "";
    }

    protected int getModelCodeIdForAES(HttpServletRequest request, String code) {
        IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
        ModelEntity model = modelBiz.getEntityByModelCode(this.decryptByAES(request, code));
        if (model != null) {
            return model.getModelId();
        }
        return 0;
    }

    @Deprecated
    protected int getModelCodeId() {
        Object obj = BasicUtil.getSession(SessionConstEnum.MODEL_ID_SESSION);
        if (obj != null) {
            return Integer.parseInt(obj.toString());
        }
        return 0;
    }

    protected int getRootModelCodeId() {
        Object obj = BasicUtil.getSession(SessionConstEnum.MODEL_ID_SESSION);
        if (NumberUtils.isNumber((String)obj.toString())) {
            IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
            ModelEntity model = (ModelEntity)modelBiz.getEntity(Integer.parseInt(obj.toString()));
            return model.getModelModelId();
        }
        return 0;
    }

    protected int getModelCodeId(HttpServletRequest request, BaseEnum code) {
        IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
        ModelEntity model = modelBiz.getEntityByModelCode(code);
        if (model != null) {
            return model.getModelId();
        }
        return 0;
    }

    protected int getModelCodeId(HttpServletRequest request, String code) {
        IModelBiz modelBiz = SpringUtil.getBean(IModelBiz.class);
        ModelEntity model = modelBiz.getEntityByModelCode(code);
        if (model != null) {
            return model.getModelId();
        }
        return 0;
    }

    protected String getCodeBySession() {
        Object obj = BasicUtil.getSession(SessionConstEnum.CODE_SESSION);
        if (obj != null) {
            return (String)obj;
        }
        return null;
    }

    protected String redirectBack(boolean flag) {
        if (flag) {
            return "redirect:" + BasicUtil.getCookie(CookieConstEnum.BACK_COOKIE);
        }
        return BasicUtil.getCookie(CookieConstEnum.BACK_COOKIE);
    }

    protected boolean checkRandCode(String param) {
        String sessionCode = this.getRandCode();
        String requestCode = BasicUtil.getString(param);
        this.LOG.debug("session_code:" + sessionCode + " requestCode:" + requestCode);
        return sessionCode.equalsIgnoreCase(requestCode);
    }

    @Deprecated
    protected String view(String path) {
        return Const.VIEW + path;
    }

    @Deprecated
    protected void removeUrlParams(HttpServletRequest request, String[] fitlers) {
        request.setAttribute("params", (Object)BasicUtil.assemblyRequestUrlParams(fitlers));
    }

    protected boolean validated(String tableName, String fieldName, String fieldValue) {
        HashMap<String, String> where = new HashMap<String, String>(1);
        where.put(fieldName, fieldValue);
        List list = this.appBiz.queryBySQL(tableName, null, where);
        return ObjectUtil.isNotNull((Object)list) && !list.isEmpty();
    }

    protected boolean validated(String tableName, String fieldName, String fieldValue, String id, String idName) {
        HashMap<String, String> where = new HashMap<String, String>(1);
        where.put(fieldName, fieldValue);
        List list = this.appBiz.queryBySQL(tableName, null, where);
        if (ObjectUtil.isNotNull((Object)list) && !list.isEmpty()) {
            return list.size() != 1 || !id.equals(((HashMap)list.get(0)).get(idName).toString());
        }
        return false;
    }
}

