/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.utils.io.serialization;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.internal.TaggedEncoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleKt;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import net.mamoe.mirai.internal.utils.io.serialization.ProtoBufWithNullableSupport$ProtobufEncoder$WhenMappings;
import net.mamoe.mirai.internal.utils.io.serialization.ProtoBufWithNullableSupportKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0007\u0014\u0015\u0016\u0017\u0018\u0019\u001aB\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J)\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\u00020\r\"\u0004\b\u0000\u0010\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u00112\u0006\u0010\u0012\u001a\u0002H\tH\u0016\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;", "Lkotlinx/serialization/SerialFormat;", "Lkotlinx/serialization/BinaryFormat;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(Lkotlinx/serialization/modules/SerializersModule;)V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeFromByteArray", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "encodeToByteArray", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "Companion", "MapRepeatedWriter", "ObjectWriter", "ProtobufEncoder", "ProtobufWriter", "RepeatedWriter", "Varint", "mirai-core"})
public final class ProtoBufWithNullableSupport
implements SerialFormat,
BinaryFormat {
    @NotNull
    private final SerializersModule serializersModule;
    public static final int VARINT = 0;
    public static final int i64 = 1;
    public static final int SIZE_DELIMITED = 2;
    public static final int i32 = 5;
    private static final ProtoBufWithNullableSupport plain;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public <T> byte[] encodeToByteArray(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        ByteArrayOutputStream encoder = new ByteArrayOutputStream();
        ProtobufWriter dumper = new ProtobufWriter(new ProtobufEncoder(encoder));
        dumper.encodeSerializableValue(serializer2, value);
        byte[] byArray = encoder.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encoder.toByteArray()");
        return byArray;
    }

    public <T> T decodeFromByteArray(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return (T)ProtoBuf.Default.decodeFromByteArray(deserializer, bytes);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public ProtoBufWithNullableSupport(@NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.serializersModule = serializersModule;
    }

    public /* synthetic */ ProtoBufWithNullableSupport(SerializersModule serializersModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            serializersModule = SerializersModuleKt.getEmptySerializersModule();
        }
        this(serializersModule);
    }

    public ProtoBufWithNullableSupport() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        plain = new ProtoBufWithNullableSupport(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0090\u0004\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J/\u0010\u0011\u001a\u00020\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\b\u0010\u0017\u001a\u0004\u0018\u0001H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0019\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00162\u0006\u0010\u0017\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018J(\u0010\u001a\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020\u001cH\u0014J(\u0010\u001d\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020\u001eH\u0014J(\u0010\u001f\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020 H\u0014J(\u0010!\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020\"H\u0014J0\u0010#\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0003H\u0014J(\u0010&\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020'H\u0014J(\u0010(\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020\u0003H\u0014J(\u0010)\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020*H\u0014J \u0010+\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0014J(\u0010,\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020-H\u0014J(\u0010.\u001a\u00020\u00122\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020/H\u0014J$\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005*\u00020\u00102\u0006\u00101\u001a\u00020\u0003H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u00062"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufWriter;", "Lkotlinx/serialization/internal/TaggedEncoder;", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoDesc;", "encoder", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;", "(Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeNullableSerializableValue", "", "T", "", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeSerializableValue", "encodeTaggedBoolean", "tag", "", "encodeTaggedByte", "", "encodeTaggedChar", "", "encodeTaggedDouble", "", "encodeTaggedEnum", "enumDescriptor", "ordinal", "encodeTaggedFloat", "", "encodeTaggedInt", "encodeTaggedLong", "", "encodeTaggedNull", "encodeTaggedShort", "", "encodeTaggedString", "", "getTag", "index", "mirai-core"})
    public class ProtobufWriter
    extends TaggedEncoder<Pair<? extends Integer, ? extends ProtoIntegerType>> {
        private final ProtobufEncoder encoder;

        @NotNull
        public SerializersModule getSerializersModule() {
            return ProtoBufWithNullableSupport.this.getSerializersModule();
        }

        @NotNull
        public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeEncoder compositeEncoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            SerialKind serialKind = descriptor.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                compositeEncoder = (CompositeEncoder)new RepeatedWriter(this.encoder, (Pair<Integer, ? extends ProtoIntegerType>)((Pair)this.getCurrentTag()));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
                compositeEncoder = (CompositeEncoder)new ObjectWriter(ProtoBufWithNullableSupport.this, (Pair)this.getCurrentTagOrNull(), this.encoder, null, 4, null);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                compositeEncoder = (CompositeEncoder)new MapRepeatedWriter((Pair<Integer, ? extends ProtoIntegerType>)((Pair)this.getCurrentTagOrNull()), this.encoder);
            } else {
                throw (Throwable)new SerializationException("Primitives are not supported at top-level");
            }
            return compositeEncoder;
        }

        protected void encodeTaggedInt(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, int value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoIntegerType)tag.getSecond());
        }

        protected void encodeTaggedByte(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, byte value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoIntegerType)tag.getSecond());
        }

        protected void encodeTaggedShort(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, short value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoIntegerType)tag.getSecond());
        }

        protected void encodeTaggedLong(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, long value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.encoder.writeLong(value, ((Number)tag.getFirst()).intValue(), (ProtoIntegerType)tag.getSecond());
        }

        protected void encodeTaggedFloat(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, float value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.encoder.writeFloat(value, ((Number)tag.getFirst()).intValue());
        }

        protected void encodeTaggedDouble(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, double value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.encoder.writeDouble(value, ((Number)tag.getFirst()).intValue());
        }

        protected void encodeTaggedBoolean(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, boolean value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.encoder.writeInt(value ? 1 : 0, ((Number)tag.getFirst()).intValue(), ProtoIntegerType.DEFAULT);
        }

        protected void encodeTaggedChar(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, char value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoIntegerType)tag.getSecond());
        }

        protected void encodeTaggedString(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, @NotNull String value) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.encoder.writeString(value, ((Number)tag.getFirst()).intValue());
        }

        protected void encodeTaggedEnum(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag, @NotNull SerialDescriptor enumDescriptor, int ordinal) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
            this.encoder.writeInt(((Number)ProtoBufWithNullableSupportKt.extractParameters(enumDescriptor, ordinal, true).getFirst()).intValue(), ((Number)tag.getFirst()).intValue(), ProtoIntegerType.DEFAULT);
        }

        @NotNull
        protected Pair<Integer, ProtoIntegerType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            return Companion.getProtoDesc($this$getTag, index);
        }

        protected void encodeTaggedNull(@NotNull Pair<Integer, ? extends ProtoIntegerType> tag) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
        }

        public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, @Nullable T value) {
            Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
            if (value == null) {
                this.encodeTaggedNull((Pair<Integer, ? extends ProtoIntegerType>)((Pair)this.popTag()));
            } else {
                this.encodeSerializableValue(serializer2, value);
            }
        }

        public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
            Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
            if (Intrinsics.areEqual((Object)serializer2.getDescriptor().getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                MapLikeSerializer serializer3 = (MapLikeSerializer)serializer2;
                KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer((KSerializer)serializer3.getKeySerializer(), (KSerializer)serializer3.getValueSerializer());
                T t = value;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                BuiltinSerializersKt.SetSerializer((KSerializer)mapEntrySerial).serialize((Encoder)this, ((Map)t).entrySet());
            } else if (Intrinsics.areEqual((Object)serializer2.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
                T t = value;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                this.encoder.writeBytes((byte[])t, ((Number)((Pair)this.popTag()).getFirst()).intValue());
            } else {
                serializer2.serialize((Encoder)this, value);
            }
        }

        public ProtobufWriter(ProtobufEncoder encoder) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            this.encoder = encoder;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0090\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B3\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ObjectWriter;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufWriter;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;", "parentTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoDesc;", "parentEncoder", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;", "stream", "Ljava/io/ByteArrayOutputStream;", "(Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;Lkotlin/Pair;Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;Ljava/io/ByteArrayOutputStream;)V", "getParentTag", "()Lkotlin/Pair;", "endEncode", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "mirai-core"})
    public class ObjectWriter
    extends ProtobufWriter {
        @Nullable
        private final Pair<Integer, ProtoIntegerType> parentTag;
        private final ProtobufEncoder parentEncoder;
        private final ByteArrayOutputStream stream;
        final /* synthetic */ ProtoBufWithNullableSupport this$0;

        protected void endEncode(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (this.parentTag != null) {
                byte[] byArray = this.stream.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stream.toByteArray()");
                this.parentEncoder.writeBytes(byArray, ((Number)this.parentTag.getFirst()).intValue());
            } else {
                this.parentEncoder.getOut().write(this.stream.toByteArray());
            }
        }

        @Nullable
        public final Pair<Integer, ProtoIntegerType> getParentTag() {
            return this.parentTag;
        }

        public ObjectWriter(@Nullable ProtoBufWithNullableSupport this$0, @NotNull Pair<Integer, ? extends ProtoIntegerType> parentTag, @NotNull ProtobufEncoder parentEncoder, ByteArrayOutputStream stream) {
            Intrinsics.checkNotNullParameter((Object)parentEncoder, (String)"parentEncoder");
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            this.this$0 = this$0;
            super(new ProtobufEncoder(stream));
            this.parentTag = parentTag;
            this.parentEncoder = parentEncoder;
            this.stream = stream;
        }

        public /* synthetic */ ObjectWriter(ProtoBufWithNullableSupport protoBufWithNullableSupport, Pair pair, ProtobufEncoder protobufEncoder, ByteArrayOutputStream byteArrayOutputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            this(protoBufWithNullableSupport, (Pair<Integer, ? extends ProtoIntegerType>)pair, protobufEncoder, byteArrayOutputStream);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B)\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007*\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0014\u00a8\u0006\u000e"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$MapRepeatedWriter;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ObjectWriter;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;", "parentTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoDesc;", "parentEncoder", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;", "(Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;Lkotlin/Pair;Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;)V", "getTag", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "mirai-core"})
    public final class MapRepeatedWriter
    extends ObjectWriter {
        @Override
        @NotNull
        protected Pair<Integer, ProtoIntegerType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            if (index % 2 == 0) {
                Integer n = 1;
                ProtoIntegerType protoIntegerType = this.getParentTag();
                if (protoIntegerType == null || (protoIntegerType = (ProtoIntegerType)protoIntegerType.getSecond()) == null) {
                    protoIntegerType = ProtoIntegerType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, (Object)protoIntegerType);
            } else {
                Integer n = 2;
                ProtoIntegerType protoIntegerType = this.getParentTag();
                if (protoIntegerType == null || (protoIntegerType = (ProtoIntegerType)protoIntegerType.getSecond()) == null) {
                    protoIntegerType = ProtoIntegerType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, (Object)protoIntegerType);
            }
            return pair;
        }

        public MapRepeatedWriter(@NotNull Pair<Integer, ? extends ProtoIntegerType> parentTag, ProtobufEncoder parentEncoder) {
            Intrinsics.checkNotNullParameter((Object)parentEncoder, (String)"parentEncoder");
            super(ProtoBufWithNullableSupport.this, parentTag, parentEncoder, null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t*\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0014R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$RepeatedWriter;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufWriter;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;", "encoder", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;", "curTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoDesc;", "(Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;Lkotlin/Pair;)V", "getTag", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "mirai-core"})
    public final class RepeatedWriter
    extends ProtobufWriter {
        private final Pair<Integer, ProtoIntegerType> curTag;

        @Override
        @NotNull
        protected Pair<Integer, ProtoIntegerType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            return this.curTag;
        }

        public RepeatedWriter(@NotNull ProtobufEncoder encoder, Pair<Integer, ? extends ProtoIntegerType> curTag) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter(curTag, (String)"curTag");
            super(encoder);
            this.curTag = curTag;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\nJ\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$ProtobufEncoder;", "", "out", "Ljava/io/ByteArrayOutputStream;", "(Ljava/io/ByteArrayOutputStream;)V", "getOut", "()Ljava/io/ByteArrayOutputStream;", "encode32", "", "number", "", "format", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "encode64", "", "writeBytes", "", "bytes", "tag", "writeDouble", "value", "", "writeFloat", "", "writeInt", "writeLong", "writeString", "", "mirai-core"})
    public static final class ProtobufEncoder {
        @NotNull
        private final ByteArrayOutputStream out;

        public final void writeBytes(@NotNull byte[] bytes, int tag) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 2, null, 2, null);
            byte[] len = ProtobufEncoder.encode32$default(this, bytes.length, null, 2, null);
            this.out.write(header);
            this.out.write(len);
            this.out.write(bytes);
        }

        public final void writeInt(int value, int tag, @NotNull ProtoIntegerType format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            int wireType = format == ProtoIntegerType.FIXED ? 5 : 0;
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | wireType, null, 2, null);
            byte[] content = this.encode32(value, format);
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeLong(long value, int tag, @NotNull ProtoIntegerType format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            int wireType = format == ProtoIntegerType.FIXED ? 1 : 0;
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | wireType, null, 2, null);
            byte[] content = this.encode64(value, format);
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeString(@NotNull String value, int tag) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] bytes = StringsKt.encodeToByteArray((String)value);
            this.writeBytes(bytes, tag);
        }

        public final void writeDouble(double value, int tag) {
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 1, null, 2, null);
            byte[] content = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(value).array();
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeFloat(float value, int tag) {
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 5, null, 2, null);
            byte[] content = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(value).array();
            this.out.write(header);
            this.out.write(content);
        }

        private final byte[] encode32(int number, ProtoIntegerType format) {
            byte[] byArray;
            switch (ProtoBufWithNullableSupport$ProtobufEncoder$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    byte[] byArray2 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(number).array();
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"ByteBuffer.allocate(4).o\u2026N).putInt(number).array()");
                    break;
                }
                case 2: {
                    byArray = Varint.INSTANCE.encodeVarint$mirai_core((long)number);
                    break;
                }
                case 3: {
                    byArray = Varint.INSTANCE.encodeVarint$mirai_core(number << 1 ^ number >> 31);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return byArray;
        }

        static /* synthetic */ byte[] encode32$default(ProtobufEncoder protobufEncoder, int n, ProtoIntegerType protoIntegerType, int n2, Object object) {
            if ((n2 & 2) != 0) {
                protoIntegerType = ProtoIntegerType.DEFAULT;
            }
            return protobufEncoder.encode32(n, protoIntegerType);
        }

        private final byte[] encode64(long number, ProtoIntegerType format) {
            byte[] byArray;
            switch (ProtoBufWithNullableSupport$ProtobufEncoder$WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
                case 1: {
                    byte[] byArray2 = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(number).array();
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"ByteBuffer.allocate(8).o\u2026).putLong(number).array()");
                    break;
                }
                case 2: {
                    byArray = Varint.INSTANCE.encodeVarint$mirai_core(number);
                    break;
                }
                case 3: {
                    byArray = Varint.INSTANCE.encodeVarint$mirai_core(number << 1 ^ number >> 63);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return byArray;
        }

        static /* synthetic */ byte[] encode64$default(ProtobufEncoder protobufEncoder, long l, ProtoIntegerType protoIntegerType, int n, Object object) {
            if ((n & 2) != 0) {
                protoIntegerType = ProtoIntegerType.DEFAULT;
            }
            return protobufEncoder.encode64(l, protoIntegerType);
        }

        @NotNull
        public final ByteArrayOutputStream getOut() {
            return this.out;
        }

        public ProtobufEncoder(@NotNull ByteArrayOutputStream out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.out = out;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$Varint;", "", "()V", "encodeVarint", "", "inp", "", "encodeVarint$mirai_core", "", "mirai-core"})
    public static final class Varint {
        @NotNull
        public static final Varint INSTANCE;

        @NotNull
        public final byte[] encodeVarint$mirai_core(int inp) {
            int value = inp;
            byte[] byteArrayList = new byte[10];
            int i = 0;
            while ((value & (int)0xFFFFFF80L) != 0) {
                byteArrayList[i++] = (byte)(value & 0x7F | 0x80);
                value >>>= 7;
            }
            byteArrayList[i] = (byte)(value & 0x7F);
            byte[] out = new byte[i + 1];
            while (i >= 0) {
                out[i] = byteArrayList[i];
                --i;
            }
            return out;
        }

        @NotNull
        public final byte[] encodeVarint$mirai_core(long inp) {
            long value = inp;
            byte[] byteArrayList = new byte[10];
            int i = 0;
            while ((value & (0x7FL ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                byteArrayList[i++] = (byte)(value & 0x7FL | 0x80L);
                value >>>= 7;
            }
            byteArrayList[i] = (byte)(value & 0x7FL);
            byte[] out = new byte[i + 1];
            while (i >= 0) {
                out[i] = byteArrayList[i];
                --i;
            }
            return out;
        }

        private Varint() {
        }

        static {
            Varint varint;
            INSTANCE = varint = new Varint();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J)\u0010\u0015\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00172\u0006\u0010\u0018\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u001bj\u0002`\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport$Companion;", "Lkotlinx/serialization/BinaryFormat;", "()V", "SIZE_DELIMITED", "", "VARINT", "i32", "i64", "plain", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoBufWithNullableSupport;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeFromByteArray", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "encodeToByteArray", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "getProtoDesc", "Lkotlin/Pair;", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "Lnet/mamoe/mirai/internal/utils/io/serialization/ProtoDesc;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "mirai-core"})
    public static final class Companion
    implements BinaryFormat {
        @NotNull
        public SerializersModule getSerializersModule() {
            return plain.getSerializersModule();
        }

        private final Pair<Integer, ProtoIntegerType> getProtoDesc(SerialDescriptor $this$getProtoDesc, int index) {
            return ProtoBufWithNullableSupportKt.extractParameters$default($this$getProtoDesc, index, false, 4, null);
        }

        @NotNull
        public <T> byte[] encodeToByteArray(@NotNull SerializationStrategy<? super T> serializer2, T value) {
            Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
            return plain.encodeToByteArray(serializer2, value);
        }

        public <T> T decodeFromByteArray(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return plain.decodeFromByteArray(deserializer, bytes);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

