/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.kaczmarzyk.spring.data.jpa.domain.ZeroArgSpecification;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class SimpleSpecificationResolver
implements HandlerMethodArgumentResolver {
    SimpleSpecificationResolver() {
    }

    public Specification<?> resolveArgument(MethodParameter param, ModelAndViewContainer mav, NativeWebRequest req, WebDataBinderFactory binderFactory) throws Exception {
        Spec def = (Spec)param.getParameterAnnotation(Spec.class);
        return this.buildSpecification(req, def);
    }

    Specification<Object> buildSpecification(NativeWebRequest req, Spec def) {
        try {
            Collection<String> args = this.resolveSpecArguments(req, def);
            if (args.isEmpty() && !this.isZeroArgSpec(def)) {
                return null;
            }
            String[] argsArray = args.toArray(new String[args.size()]);
            return this.newSpecification(def, argsArray);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Does the specification class expose at least one of the supported constuctors?\nIt can be either 2-arg (String path, String[] args) or 3-arg (String path, String[] args, String[] config)", e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isZeroArgSpec(Spec def) {
        return ZeroArgSpecification.class.isAssignableFrom(def.spec());
    }

    private Specification<Object> newSpecification(Spec def, String[] argsArray) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Specification spec = def.config().length == 0 ? def.spec().getConstructor(String.class, String[].class).newInstance(def.path(), argsArray) : def.spec().getConstructor(String.class, String[].class, String[].class).newInstance(def.path(), argsArray, def.config());
        return spec;
    }

    private Collection<String> resolveSpecArguments(NativeWebRequest req, Spec specDef) {
        if (specDef.constVal().length != 0) {
            return Arrays.asList(specDef.constVal());
        }
        return this.resolveSpecArgumentsFromHttpParameters(req, specDef);
    }

    private Collection<String> resolveSpecArgumentsFromHttpParameters(NativeWebRequest req, Spec specDef) {
        ArrayList<String> args = new ArrayList<String>();
        if (specDef.params().length != 0) {
            for (String webParamName : specDef.params()) {
                String[] httpParamValues = req.getParameterValues(webParamName);
                this.addValuesToArgs(httpParamValues, args);
            }
        } else {
            String[] httpParamValues = req.getParameterValues(specDef.path());
            this.addValuesToArgs(httpParamValues, args);
        }
        return args;
    }

    private void addValuesToArgs(String[] paramValues, Collection<String> args) {
        if (paramValues != null) {
            for (String paramValue : paramValues) {
                if (StringUtils.isEmpty((CharSequence)paramValue)) continue;
                args.add(paramValue);
            }
        }
    }

    public boolean supportsParameter(MethodParameter param) {
        return param.getParameterType() == Specification.class && param.hasParameterAnnotation(Spec.class);
    }
}

