/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Converter {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private String dateFormat;

    private Converter(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public <T> T convert(String value, Class<T> expectedClass) {
        if (expectedClass.isEnum()) {
            return this.convertToEnum(value, expectedClass);
        }
        if (expectedClass.isAssignableFrom(Date.class)) {
            return (T)this.convertToDate(value);
        }
        if (expectedClass.isAssignableFrom(Boolean.class) || expectedClass.isAssignableFrom(Boolean.TYPE)) {
            return (T)this.convertToBoolean(value);
        }
        return (T)value;
    }

    public <T> List<T> convert(List<String> values, Class<T> expectedClass) {
        if (expectedClass == String.class) {
            return values;
        }
        ArrayList<String> rejected = null;
        ArrayList<T> result = new ArrayList<T>();
        for (String value : values) {
            try {
                result.add(this.convert(value, expectedClass));
            }
            catch (ValueRejectedException e) {
                if (rejected == null) {
                    rejected = new ArrayList<String>();
                }
                rejected.add(e.getRejectedValue());
            }
        }
        if (rejected != null) {
            throw new ValuesRejectedException(rejected, "rejected values " + rejected + " for class " + expectedClass.getSimpleName());
        }
        return result;
    }

    private Boolean convertToBoolean(String value) {
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("unrecognized boolean: " + value);
    }

    public Date convertToDate(String value) {
        try {
            return new SimpleDateFormat(this.dateFormat).parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private <T> T convertToEnum(String value, Class<? extends Enum<?>> enumClass) {
        for (Enum<?> enumVal : enumClass.getEnumConstants()) {
            if (!enumVal.name().equals(value)) continue;
            return (T)enumVal;
        }
        throw new ValueRejectedException(value, "could not find value " + value + " for enum class " + enumClass.getSimpleName());
    }

    public static Converter withDateFormat(String dateFormat) {
        return new Converter(dateFormat != null ? dateFormat : DEFAULT_DATE_FORMAT);
    }

    private static class ValueRejectedException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private String rejectedValue;

        public ValueRejectedException(String constantName, String message) {
            super(message);
            this.rejectedValue = constantName;
        }

        public String getRejectedValue() {
            return this.rejectedValue;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.getMessage();
        }
    }

    public static class ValuesRejectedException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private Collection<String> rejectedValues;

        public ValuesRejectedException(Collection<String> rejectedValues, String message) {
            super(message);
            this.rejectedValues = rejectedValues;
        }

        public Collection<String> getRejectedValues() {
            return this.rejectedValues;
        }

        @Override
        public String toString() {
            return this.getClass() + ": " + this.getMessage();
        }
    }
}

