/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;

public class Equal<T>
extends PathSpecification<T> {
    private String expectedValue;
    private Converter converter;

    public Equal(String path, String[] httpParamValues) {
        this(path, httpParamValues, null);
    }

    public Equal(String path, String[] httpParamValues, String[] config) {
        super(path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException();
        }
        if (config != null && config.length != 1) {
            throw new IllegalArgumentException("config may contain only one value (date format), but was: " + config);
        }
        String dateFormat = config != null ? config[0] : null;
        this.expectedValue = httpParamValues[0];
        this.converter = Converter.withDateFormat(dateFormat);
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Class typeOnPath = this.path(root).getJavaType();
        return cb.equal(this.path(root), this.converter.convert(this.expectedValue, typeOnPath));
    }
}

