/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.resource.linux.LinuxResources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;

public class LinuxAppBundler
extends Bundler {
    private BundleParams params = null;
    protected static final String LINUX_BUNDLER_PREFIX = "package/linux" + File.separator;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String LAUNCHER_CLASS = "com.javafx.main.Main";

    boolean validate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (p.type != Bundler.BundleType.ALL && p.type != Bundler.BundleType.IMAGE) {
            return false;
        }
        return this.doValidate(p);
    }

    boolean doValidate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            throw new Bundler.UnsupportedPlatformException();
        }
        if (LinuxResources.class.getResource(EXECUTABLE_NAME) == null) {
            throw new Bundler.ConfigException("This copy of ant-javafx.jar does not support Linux.", "Please use ant-javafx.jar coming with Oracle JDK for Linux.");
        }
        if (p.getMainApplicationJar() == null) {
            throw new Bundler.ConfigException("Main application jar is missing.", "Make sure to use fx:jar task to create main application jar.");
        }
        this.testRuntime(p, "lib/jfxrt.jar");
        this.testRuntime(p, "lib/rt.jar");
        return true;
    }

    private static File getRootDir(File outDir, BundleParams p) {
        return new File(outDir, LinuxAppBundler.getLauncherName(p));
    }

    private static String getLauncherName(BundleParams p) {
        String nm = p.name != null ? p.name : p.getMainClassName();
        nm = nm.replaceAll(" ", "");
        return nm;
    }

    public static File getLauncher(File outDir, BundleParams p) {
        return new File(LinuxAppBundler.getRootDir(outDir, p), LinuxAppBundler.getLauncherName(p));
    }

    public boolean bundle(BundleParams p, File outputDirectory) {
        return this.doBundle(p, outputDirectory, false);
    }

    boolean doBundle(BundleParams p, File outputDirectory, boolean dependentTask) {
        try {
            this.params = p;
            File rootDirectory = new File(outputDirectory, LinuxAppBundler.getLauncherName(p));
            IOUtils.deleteRecursive(rootDirectory);
            rootDirectory.mkdirs();
            if (!dependentTask) {
                Log.info("Creating app bundle: " + rootDirectory.getAbsolutePath());
            }
            File runtimeDirectory = new File(rootDirectory, "runtime");
            File appDirectory = new File(rootDirectory, "app");
            appDirectory.mkdirs();
            File executableFile = LinuxAppBundler.getLauncher(outputDirectory, p);
            IOUtils.copyFromURL(LinuxResources.class.getResource(EXECUTABLE_NAME), executableFile);
            executableFile.setExecutable(true, false);
            executableFile.setWritable(true, true);
            File pkgInfoFile = new File(appDirectory, "package.cfg");
            pkgInfoFile.createNewFile();
            this.writePkgInfo(pkgInfoFile);
            this.copyRuntime(runtimeDirectory);
            this.copyApplication(appDirectory);
        }
        catch (IOException ex) {
            System.out.println("Exception: " + ex);
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public String toString() {
        return "Linux Application Bundler";
    }

    private void copyApplication(File appDirectory) throws IOException {
        if (this.params.appResources == null) {
            throw new RuntimeException("Null app resources?");
        }
        File srcdir = this.params.appResources.getBaseDirectory();
        for (String fname : this.params.appResources.getIncludedFiles()) {
            IOUtils.copyFile(new File(srcdir, fname), new File(appDirectory, fname));
        }
    }

    private void writePkgInfo(File pkgInfoFile) throws FileNotFoundException {
        pkgInfoFile.delete();
        PrintStream out = new PrintStream(pkgInfoFile);
        out.println("app.mainjar=" + this.params.getMainApplicationJar());
        out.println("app.version=" + this.params.appVersion);
        if (this.params.useJavaFXPackaging()) {
            out.println("app.mainclass=" + LAUNCHER_CLASS.replaceAll("\\.", "/"));
        } else {
            out.println("app.mainclass=" + this.params.applicationClass.replaceAll("\\.", "/"));
        }
        out.println("app.classpath=" + this.params.getAppClassPath());
        List<String> jvmargs = this.params.getAllJvmOptions();
        int idx = 1;
        for (String a : jvmargs) {
            out.println("jvmarg." + idx + "=" + a);
            ++idx;
        }
        out.close();
    }

    private void copyRuntime(File runtimeDirectory) throws IOException {
        if (this.params.runtime == null) {
            return;
        }
        runtimeDirectory.mkdirs();
        File srcdir = this.params.runtime.getBaseDirectory();
        File destDir = new File(runtimeDirectory, srcdir.getName());
        Set<String> filesToCopy = this.params.runtime.getIncludedFiles();
        for (String fname : filesToCopy) {
            IOUtils.copyFile(new File(srcdir, fname), new File(destDir, fname));
        }
    }
}

