/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.packager.bundlers.RelativeFileSet;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleParams {
    boolean useDefaultRuntime = true;
    RelativeFileSet runtime;
    RelativeFileSet appResources;
    Bundler.BundleType type;
    String bundleFormat;
    File icon;
    String name = null;
    String vendor = null;
    String copyright = null;
    String identifier = null;
    boolean needShortcut = false;
    boolean needMenu = false;
    String appVersion = null;
    String applicationCategory;
    String title;
    String description = null;
    String licenseType = null;
    List<String> licenseFile = new LinkedList<String>();
    Boolean systemWide = false;
    String applicationClass;
    List<String> jvmargs = new LinkedList<String>();
    Map<String, String> jvmProperties = new HashMap<String, String>();
    Rule[] macRules = new Rule[]{Rule.suffixNeg("macos/libjli.dylib"), Rule.suffixNeg("resources"), Rule.suffixNeg("home/bin"), Rule.suffixNeg("home/db"), Rule.suffixNeg("home/demo"), Rule.suffixNeg("home/include"), Rule.suffixNeg("home/lib"), Rule.suffixNeg("home/man"), Rule.suffixNeg("home/release"), Rule.suffixNeg("home/sample"), Rule.suffixNeg("home/src.zip"), Rule.suffixNeg("home/rt"), Rule.suffixNeg("jre/bin"), Rule.suffixNeg("jre/bin/rmiregistry"), Rule.suffixNeg("jre/bin/tnameserv"), Rule.suffixNeg("jre/bin/keytool"), Rule.suffixNeg("jre/bin/klist"), Rule.suffixNeg("jre/bin/ktab"), Rule.suffixNeg("jre/bin/policytool"), Rule.suffixNeg("jre/bin/orbd"), Rule.suffixNeg("jre/bin/servertool"), Rule.suffixNeg("jre/bin/javaws"), Rule.suffixNeg("jre/bin/java"), Rule.suffixNeg("jre/lib/nibs"), Rule.suffixNeg("jre/lib/libnpjp2.dylib"), Rule.suffixNeg("jre/lib/security/javaws.policy")};
    Rule[] winRules = new Rule[]{Rule.prefixNeg("\\bin\\new_plugin"), Rule.suffix("deploy.jar"), Rule.prefixNeg("\\lib\\deploy"), Rule.suffixNeg(".pdb"), Rule.suffixNeg(".map"), Rule.suffixNeg("axbridge.dll"), Rule.suffixNeg("eula.dll"), Rule.substrNeg("javacpl"), Rule.suffixNeg("wsdetect.dll"), Rule.substrNeg("eployjava1.dll"), Rule.substrNeg("bin\\jp2"), Rule.substrNeg("bin\\jpi"), Rule.suffixNeg("ssv.dll"), Rule.substrNeg("npjpi"), Rule.substrNeg("npoji"), Rule.suffixNeg(".exe"), Rule.suffix(".jar")};
    Rule[] linuxRules = new Rule[]{Rule.prefixNeg("/bin"), Rule.prefixNeg("/plugin"), Rule.suffix("deploy.jar"), Rule.prefixNeg("/lib/deploy"), Rule.prefixNeg("/lib/desktop"), Rule.substrNeg("libnpjp2.so")};
    private String mainJar = null;
    private String mainJarClassPath = null;
    private boolean useFXPackaging = true;

    public void setJvmargs(List<String> jvmargs) {
        this.jvmargs = jvmargs;
    }

    public void setJvmProperties(Map<String, String> jvmProperties) {
        this.jvmProperties = jvmProperties;
    }

    public List<String> getAllJvmOptions() {
        LinkedList<String> all = new LinkedList<String>();
        all.addAll(this.jvmargs);
        for (String k : this.jvmProperties.keySet()) {
            all.add("-D" + k + "=" + this.jvmProperties.get(k));
        }
        return all;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public void setAppVersion(String version) {
        this.appVersion = version;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public void setLicenseType(String version) {
        this.licenseType = version;
    }

    public void addLicenseFile(String path) {
        this.licenseFile.add(path);
    }

    public void setSystemWide(Boolean b) {
        this.systemWide = b;
    }

    public RelativeFileSet getRuntime() {
        return this.runtime;
    }

    public void setShortcutHint(boolean v) {
        this.needShortcut = v;
    }

    public void setMenuHint(boolean v) {
        this.needMenu = v;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Bundler.BundleType type) {
        this.type = type;
    }

    public void setBundleFormat(String t) {
        this.bundleFormat = t;
    }

    private boolean shouldExclude(File baseDir, File f, Rule[] ruleset) {
        if (ruleset == null) {
            return false;
        }
        String fname = f.getAbsolutePath().toLowerCase().substring(baseDir.getAbsolutePath().length());
        for (Rule r : ruleset) {
            if (!r.match(fname)) continue;
            return !r.treatAsAccept();
        }
        return false;
    }

    private void walk(File base, File root, Rule[] ruleset, Set<File> files) {
        File[] lst;
        if (!root.isDirectory()) {
            if (root.isFile()) {
                files.add(root);
            }
            return;
        }
        for (File f : lst = root.listFiles()) {
            if (!IOUtils.isNotSymbolicLink(f) || this.shouldExclude(base, f, ruleset)) continue;
            if (f.isDirectory()) {
                this.walk(base, f, ruleset, files);
                continue;
            }
            if (!f.isFile()) continue;
            files.add(f);
        }
    }

    private static boolean checkJDKRoot(File jdkRoot) {
        File rtJar = new File(jdkRoot, "jre/lib/rt.jar");
        if (!rtJar.exists()) {
            Log.verbose("rt.jar is not found at " + rtJar.getAbsolutePath());
            return false;
        }
        File jfxJar = new File(jdkRoot, "jre/lib/jfxrt.jar");
        if (!jfxJar.exists()) {
            Log.verbose("jfxrt.jar is not found at " + jfxJar.getAbsolutePath());
            return false;
        }
        File toolsJar = new File(jdkRoot, "lib/tools.jar");
        if (!toolsJar.exists()) {
            Log.verbose("tools.jar is not found at " + toolsJar.getAbsolutePath());
            return false;
        }
        return true;
    }

    static File validateRuntimeLocation(File javaHome) {
        File jdkRoot;
        if (javaHome == null) {
            return null;
        }
        boolean isMac = System.getProperty("os.name").toLowerCase().contains("os x");
        File rtJar = new File(javaHome, "lib/rt.jar");
        if (rtJar.exists()) {
            jdkRoot = javaHome.getParentFile();
        } else {
            File f;
            if (isMac && (f = new File(javaHome, "Contents/Home")).exists() && f.isDirectory()) {
                javaHome = f;
            }
            jdkRoot = javaHome;
        }
        if (!BundleParams.checkJDKRoot(jdkRoot)) {
            throw new RuntimeException("Can not find JDK artifacts in specified location: " + javaHome.getAbsolutePath());
        }
        return new File(jdkRoot, "jre");
    }

    public void setRuntime(File baseDir) {
        if ((baseDir = BundleParams.validateRuntimeLocation(baseDir)) == null) {
            Log.verbose("No Java runtime to embed. Package will need system Java.");
            this.runtime = null;
            return;
        }
        this.doSetRuntime(baseDir);
        this.useDefaultRuntime = false;
    }

    public void setDefaultRuntime() {
        File f = new File(System.getProperty("java.home"));
        this.doSetRuntime(f);
    }

    private void doSetRuntime(File baseDir) {
        boolean isMac = System.getProperty("os.name").toLowerCase().contains("os x");
        if (isMac) {
            baseDir = baseDir.getParentFile().getParentFile().getParentFile();
        }
        HashSet<File> lst = new HashSet<File>();
        Rule[] ruleset = System.getProperty("os.name").startsWith("Mac") ? this.macRules : (System.getProperty("os.name").startsWith("Win") ? this.winRules : this.linuxRules);
        this.walk(baseDir, baseDir, ruleset, lst);
        this.runtime = new RelativeFileSet(baseDir, lst);
    }

    public void setAppResource(RelativeFileSet fs) {
        this.appResources = fs;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public void setApplicationCategory(String category) {
        this.applicationCategory = category;
    }

    String getMainClassName() {
        if (this.applicationClass == null) {
            return null;
        }
        int idx = this.applicationClass.lastIndexOf(".");
        if (idx >= 0) {
            return this.applicationClass.substring(idx + 1);
        }
        return this.applicationClass;
    }

    public void setCopyright(String c) {
        this.copyright = c;
    }

    public void setIdentifier(String s) {
        this.identifier = s;
    }

    public boolean useJavaFXPackaging() {
        if (this.mainJar == null) {
            this.getMainApplicationJar();
        }
        return this.useFXPackaging;
    }

    public String getAppClassPath() {
        if (this.mainJar == null) {
            this.getMainApplicationJar();
        }
        if (this.useFXPackaging || this.mainJarClassPath == null) {
            return "";
        }
        return this.mainJarClassPath;
    }

    public String getMainApplicationJar() {
        if (this.mainJar != null) {
            return this.mainJar;
        }
        if (this.appResources == null || this.applicationClass == null) {
            return null;
        }
        File srcdir = this.appResources.getBaseDirectory();
        for (String fname : this.appResources.getIncludedFiles()) {
            try {
                JarFile jf = new JarFile(new File(srcdir, fname));
                Manifest m = jf.getManifest();
                Attributes attrs = m != null ? m.getMainAttributes() : null;
                if (attrs == null) continue;
                boolean javaMain = this.applicationClass.equals(attrs.getValue(Attributes.Name.MAIN_CLASS));
                boolean fxMain = this.applicationClass.equals(attrs.getValue("JavaFX-Application-Class"));
                if (!javaMain && !fxMain) continue;
                this.useFXPackaging = fxMain;
                this.mainJar = fname;
                this.mainJarClassPath = attrs.getValue(Attributes.Name.CLASS_PATH);
                return this.mainJar;
            }
            catch (IOException ex) {
            }
        }
        return null;
    }

    public void setVendor(String vendor) {
        if (vendor != null) {
            this.vendor = vendor;
        }
    }

    static class Rule {
        String regex;
        boolean includeRule;
        Type type;

        private Rule(String regex, boolean includeRule, Type type) {
            this.regex = regex;
            this.type = type;
            this.includeRule = includeRule;
        }

        boolean match(String str) {
            if (this.type == Type.SUFFIX) {
                return str.endsWith(this.regex);
            }
            if (this.type == Type.PREFIX) {
                return str.startsWith(this.regex);
            }
            if (this.type == Type.SUBSTR) {
                return str.contains(this.regex);
            }
            return str.matches(this.regex);
        }

        boolean treatAsAccept() {
            return this.includeRule;
        }

        static Rule suffix(String s) {
            return new Rule(s, true, Type.SUFFIX);
        }

        static Rule suffixNeg(String s) {
            return new Rule(s, false, Type.SUFFIX);
        }

        static Rule prefix(String s) {
            return new Rule(s, true, Type.PREFIX);
        }

        static Rule prefixNeg(String s) {
            return new Rule(s, false, Type.PREFIX);
        }

        static Rule substr(String s) {
            return new Rule(s, true, Type.SUBSTR);
        }

        static Rule substrNeg(String s) {
            return new Rule(s, false, Type.SUBSTR);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Type {
            SUFFIX,
            PREFIX,
            SUBSTR,
            REGEX;

        }
    }
}

