/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.sun.javafx.tools.ant.Callback;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.CreateBSSParams;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.HtmlParam;
import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.MakeAllParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.SignJarParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/javafx/tools/packager/Bundle");
    private static final String version = bundle.getString("MSG_Version") + " " + "2.2" + "\n";
    private static final String help = bundle.getString("MSG_Help");
    private static boolean verbose = false;
    private static boolean packageAsJar = false;
    private static boolean genJNLP = false;
    private static boolean css2Bin = false;
    private static boolean signJar = false;
    private static boolean makeAll = false;

    private static String nextArg(String[] args, int i) {
        return i == args.length - 1 ? "" : args[i + 1];
    }

    private static void addResources(CommonParams commonParams, File baseDir, String s) {
        String[] pathArray;
        if (s == null || "".equals(s)) {
            return;
        }
        for (String path : pathArray = s.split(File.pathSeparator)) {
            commonParams.addResource(baseDir, path);
        }
    }

    private static void addArgument(DeployParams deployParams, String argument) {
        if (deployParams.arguments != null) {
            deployParams.arguments.add(argument);
        } else {
            LinkedList<String> list = new LinkedList<String>();
            list.add(argument);
            deployParams.setArguments(list);
        }
    }

    private static void addArgument(CreateJarParams deployParams, String argument) {
        if (deployParams.arguments != null) {
            deployParams.arguments.add(argument);
        } else {
            LinkedList<String> list = new LinkedList<String>();
            list.add(argument);
            deployParams.setArguments(list);
        }
    }

    private static Map<String, String> createAttrMap(String arg) {
        String[] pairsArray;
        HashMap<String, String> map = new HashMap<String, String>();
        if (arg == null || "".equals(arg)) {
            return null;
        }
        for (String pair : pairsArray = arg.split(",")) {
            String[] attr = pair.split("=");
            map.put(attr[0].trim(), attr[1].trim());
        }
        return map;
    }

    private static List<Param> parseParams(String filename) throws IOException {
        File paramFile = new File(filename);
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(paramFile);
        properties.load(in);
        in.close();
        ArrayList<Param> parameters = new ArrayList<Param>(properties.size());
        if (properties != null) {
            for (Map.Entry<Object, Object> en : properties.entrySet()) {
                Param p = new Param();
                p.setName((String)en.getKey());
                p.setValue((String)en.getValue());
                parameters.add(p);
            }
        }
        return parameters;
    }

    private static List<HtmlParam> parseHtmlParams(String filename) throws IOException {
        File paramFile = new File(filename);
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(paramFile);
        properties.load(in);
        in.close();
        ArrayList<HtmlParam> parameters = new ArrayList<HtmlParam>(properties.size());
        if (properties != null) {
            for (Map.Entry<Object, Object> en : properties.entrySet()) {
                HtmlParam p = new HtmlParam();
                p.setName((String)en.getKey());
                p.setValue((String)en.getValue());
                parameters.add(p);
            }
        }
        return parameters;
    }

    private static List<Callback> parseCallbacks(String param) {
        String[] callbacks = param.split(",");
        ArrayList<Callback> list = new ArrayList<Callback>(callbacks.length);
        for (String cb : callbacks) {
            String[] nameCmd = cb.split(":");
            if (nameCmd.length != 2) continue;
            list.add(new Callback(nameCmd[0], nameCmd[1]));
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length == 1 && args[0].equals("-help")) {
            System.out.println(help);
        } else if (args.length == 1 && args[0].equals("-version")) {
            System.out.println(version);
        } else {
            PackagerLib packager = new PackagerLib();
            CreateJarParams createJarParams = new CreateJarParams();
            DeployParams deployParams = new DeployParams();
            CreateBSSParams createBssParams = new CreateBSSParams();
            SignJarParams signJarParams = new SignJarParams();
            MakeAllParams makeAllParams = new MakeAllParams();
            File srcdir = null;
            try {
                if (args[0].equalsIgnoreCase("-createjar")) {
                    boolean srcfilesSet = false;
                    for (int i = 1; i < args.length; ++i) {
                        String arg = args[i];
                        if (arg.equalsIgnoreCase("-appclass")) {
                            createJarParams.setApplicationClass(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-preloader")) {
                            createJarParams.setPreloader(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-classpath")) {
                            createJarParams.setClasspath(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-manifestAttrs")) {
                            createJarParams.setManifestAttrs(Main.createAttrMap(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-noembedlauncher")) {
                            createJarParams.setEmbedLauncher(false);
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-nocss2bin")) {
                            createJarParams.setCss2bin(false);
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-runtimeVersion")) {
                            createJarParams.setFxVersion(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-verbose") || arg.equalsIgnoreCase("-v")) {
                            createJarParams.setVerbose(true);
                            verbose = true;
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-outdir")) {
                            createJarParams.setOutdir(new File(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-outfile")) {
                            createJarParams.setOutfile(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-srcdir")) {
                            srcdir = new File(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-srcfiles")) {
                            Main.addResources(createJarParams, srcdir, Main.nextArg(args, i++));
                            srcfilesSet = true;
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-argument")) {
                            Main.addArgument(createJarParams, Main.nextArg(args, i++));
                            continue;
                        }
                        if (!arg.equalsIgnoreCase("-paramFile")) continue;
                        createJarParams.setParams(Main.parseParams(Main.nextArg(args, i++)));
                    }
                    if (!srcfilesSet) {
                        if (srcdir == null) {
                            throw new PackagerException("ERR_MissingArgument", "-srcfiles (-srcdir)");
                        }
                        Main.addResources(createJarParams, srcdir, ".");
                    }
                    packageAsJar = true;
                } else if (args[0].equalsIgnoreCase("-deploy")) {
                    boolean srcfilesSet = false;
                    File templateInFile = null;
                    File templateOutFile = null;
                    deployParams.setEmbedJNLP(false);
                    for (int i = 1; i < args.length; ++i) {
                        String arg = args[i];
                        if (arg.equalsIgnoreCase("-title")) {
                            deployParams.setTitle(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-vendor")) {
                            deployParams.setVendor(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-native")) {
                            Bundler.BundleType type = Bundler.BundleType.ALL;
                            String format = null;
                            if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                                String v = args[i + 1];
                                if ("image".equals(v)) {
                                    type = Bundler.BundleType.IMAGE;
                                } else if ("installer".equals(v)) {
                                    type = Bundler.BundleType.INSTALLER;
                                } else {
                                    type = Bundler.BundleType.INSTALLER;
                                    format = v != null ? v.toLowerCase() : null;
                                }
                            }
                            deployParams.setBundleType(type);
                            deployParams.setTargetFormat(format);
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-description")) {
                            deployParams.setDescription(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-appclass")) {
                            deployParams.setApplicationClass(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-preloader")) {
                            deployParams.setPreloader(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-paramFile")) {
                            deployParams.setParams(Main.parseParams(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-htmlParamFile")) {
                            deployParams.setHtmlParams(Main.parseHtmlParams(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-width")) {
                            deployParams.setWidth(Integer.parseInt(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-height")) {
                            deployParams.setHeight(Integer.parseInt(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-name")) {
                            deployParams.setAppName(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-embedJNLP")) {
                            deployParams.setEmbedJNLP(true);
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-embedCertificates")) {
                            deployParams.setEmbedCertifcates(true);
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-allpermissions")) {
                            deployParams.setAllPermissions(true);
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-updatemode")) {
                            deployParams.setUpdateMode(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-isExtension")) {
                            deployParams.setExtension(true);
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-callbacks")) {
                            deployParams.setCallbacks(Main.parseCallbacks(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-templateInFilename")) {
                            templateInFile = new File(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-templateOutFilename")) {
                            templateOutFile = new File(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-appId")) {
                            deployParams.setAppId(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-verbose") || arg.equalsIgnoreCase("-v")) {
                            deployParams.setVerbose(true);
                            verbose = true;
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-includedt")) {
                            deployParams.setIncludeDT(true);
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-outdir")) {
                            deployParams.setOutdir(new File(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-outfile")) {
                            deployParams.setOutfile(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-srcdir")) {
                            srcdir = new File(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-srcfiles")) {
                            Main.addResources(deployParams, srcdir, Main.nextArg(args, i++));
                            srcfilesSet = true;
                            continue;
                        }
                        if (!arg.equalsIgnoreCase("-argument")) continue;
                        Main.addArgument(deployParams, Main.nextArg(args, i++));
                    }
                    if (templateInFile != null) {
                        deployParams.addTemplate(templateInFile, templateOutFile);
                    }
                    if (!srcfilesSet) {
                        if (srcdir == null) {
                            throw new PackagerException("ERR_MissingArgument", "-srcfiles (-srcdir)");
                        }
                        Main.addResources(deployParams, srcdir, ".");
                    }
                    genJNLP = true;
                } else if (args[0].equalsIgnoreCase("-createbss")) {
                    boolean srcfilesSet = false;
                    for (int i = 1; i < args.length; ++i) {
                        String arg = args[i];
                        if (arg.equalsIgnoreCase("-verbose") || arg.equalsIgnoreCase("-v")) {
                            createBssParams.setVerbose(true);
                            verbose = true;
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-outdir")) {
                            createBssParams.setOutdir(new File(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-srcdir")) {
                            srcdir = new File(Main.nextArg(args, i++));
                            continue;
                        }
                        if (!arg.equalsIgnoreCase("-srcfiles")) continue;
                        Main.addResources(createBssParams, srcdir, Main.nextArg(args, i++));
                        srcfilesSet = true;
                    }
                    if (!srcfilesSet) {
                        if (srcdir == null) {
                            throw new PackagerException("ERR_MissingArgument", "-srcfiles (-srcdir)");
                        }
                        Main.addResources(createBssParams, srcdir, ".");
                    }
                    css2Bin = true;
                } else if (args[0].equalsIgnoreCase("-signJar")) {
                    boolean srcfilesSet = false;
                    for (int i = 1; i < args.length; ++i) {
                        String arg = args[i];
                        if (arg.equalsIgnoreCase("-keyStore")) {
                            signJarParams.setKeyStore(new File(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-alias")) {
                            signJarParams.setAlias(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-storePass")) {
                            signJarParams.setStorePass(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-keyPass")) {
                            signJarParams.setKeyPass(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-storeType")) {
                            signJarParams.setStoreType(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-verbose") || arg.equalsIgnoreCase("-v")) {
                            signJarParams.setVerbose(true);
                            verbose = true;
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-outdir")) {
                            signJarParams.setOutdir(new File(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-srcdir")) {
                            srcdir = new File(Main.nextArg(args, i++));
                            continue;
                        }
                        if (!arg.equalsIgnoreCase("-srcfiles")) continue;
                        Main.addResources(signJarParams, srcdir, Main.nextArg(args, i++));
                        srcfilesSet = true;
                    }
                    if (!srcfilesSet) {
                        if (srcdir == null) {
                            throw new PackagerException("ERR_MissingArgument", "-srcfiles (-srcdir)");
                        }
                        Main.addResources(signJarParams, srcdir, ".");
                    }
                    signJar = true;
                } else if (args[0].equalsIgnoreCase("-makeall")) {
                    for (int i = 1; i < args.length; ++i) {
                        String arg = args[i];
                        if (arg.equalsIgnoreCase("-appclass")) {
                            makeAllParams.setAppClass(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-preloader")) {
                            makeAllParams.setPreloader(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-classpath")) {
                            makeAllParams.setClasspath(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-name")) {
                            makeAllParams.setAppName(Main.nextArg(args, i++));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-width")) {
                            makeAllParams.setWidth(Integer.parseInt(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (arg.equalsIgnoreCase("-height")) {
                            makeAllParams.setHeight(Integer.parseInt(Main.nextArg(args, i++)));
                            continue;
                        }
                        if (!arg.equalsIgnoreCase("-v")) continue;
                        makeAllParams.setVerbose(true);
                    }
                    makeAll = true;
                } else {
                    System.err.println(MessageFormat.format(bundle.getString("ERR_UnknownCommand"), args[0]));
                    System.exit(-1);
                }
                if (verbose) {
                    Log.setLogger(new Log.Logger(true));
                } else {
                    Log.setLogger(new Log.Logger(false));
                }
                if (css2Bin) {
                    createBssParams.validate();
                    packager.generateBSS(createBssParams);
                }
                if (packageAsJar) {
                    createJarParams.validate();
                    packager.packageAsJar(createJarParams);
                }
                if (genJNLP) {
                    deployParams.validate();
                    packager.generateDeploymentPackages(deployParams);
                }
                if (signJar) {
                    signJarParams.validate();
                    packager.signJar(signJarParams);
                }
                if (makeAll) {
                    makeAllParams.validate();
                    packager.makeAll(makeAllParams);
                }
            }
            catch (Exception e) {
                if (verbose) {
                    throw e;
                }
                System.err.println(e.getMessage());
                System.exit(-1);
            }
        }
    }
}

