/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.AntLog;
import com.sun.javafx.tools.ant.Application;
import com.sun.javafx.tools.ant.Callbacks;
import com.sun.javafx.tools.ant.FileSet;
import com.sun.javafx.tools.ant.Info;
import com.sun.javafx.tools.ant.Platform;
import com.sun.javafx.tools.ant.Preferences;
import com.sun.javafx.tools.ant.Resources;
import com.sun.javafx.tools.ant.Utils;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;

public class DeployFXTask
extends Task {
    private String width = null;
    private String height = null;
    private String embeddedWidth = null;
    private String embeddedHeight = null;
    private String outfile = null;
    private String outdir = null;
    private boolean embedJNLP;
    private boolean isExtension = false;
    private boolean includeDT = false;
    private String updateMode = "background";
    private Info appInfo = null;
    private Application app = null;
    private Resources resources = null;
    private Preferences prefs = null;
    private String codebase = null;
    private String placeholder;
    private PackagerLib packager;
    private DeployParams deployParams;
    private Callbacks callbacks;
    boolean offlineAllowed = true;
    Bundler.BundleType nativeBundles = Bundler.BundleType.NONE;
    String bundleFormat = null;
    private boolean verbose = false;
    List<Template> templateList = new LinkedList<Template>();
    Platform platform;
    private Permissions perms = null;

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setCodebase(String str) {
        this.codebase = str;
    }

    public DeployFXTask() {
        this.packager = new PackagerLib();
        this.deployParams = new DeployParams();
    }

    public void execute() {
        this.deployParams.setOutfile(this.outfile);
        this.deployParams.setOutdir(new File(this.outdir));
        this.deployParams.setOfflineAllowed(this.offlineAllowed);
        this.deployParams.setVerbose(this.verbose);
        this.deployParams.setCodebase(this.codebase);
        if (this.width != null) {
            this.deployParams.setWidth(Integer.valueOf(this.width));
        }
        if (this.height != null) {
            this.deployParams.setHeight(Integer.valueOf(this.height));
        }
        if (this.embeddedWidth != null && this.embeddedHeight != null) {
            this.deployParams.setEmbeddedDimensions(this.embeddedWidth, this.embeddedHeight);
        }
        this.deployParams.setEmbedJNLP(this.embedJNLP);
        if (this.perms != null) {
            this.deployParams.setEmbedCertifcates(this.perms.embed);
            this.deployParams.setAllPermissions(this.perms.elevated);
        }
        if (this.app != null) {
            this.deployParams.setApplicationClass(this.app.get().mainClass);
            this.deployParams.setPreloader(this.app.get().preloaderClass);
            this.deployParams.setAppId(this.app.get().id);
            this.deployParams.setAppName(this.app.get().name);
            this.deployParams.setParams(this.app.get().parameters);
            this.deployParams.setArguments(this.app.get().getArguments());
            this.deployParams.setHtmlParams(this.app.get().htmlParameters);
            this.deployParams.setFallback(this.app.get().fallbackApp);
            this.deployParams.setSwingAppWithEmbeddedJavaFX(this.app.get().embeddedIntoSwing);
            this.deployParams.setVersion(this.app.get().version);
            this.deployParams.setId(this.app.get().id);
        }
        if (this.appInfo != null) {
            this.deployParams.setTitle(this.appInfo.title);
            this.deployParams.setVendor(this.appInfo.vendor);
            this.deployParams.setDescription(this.appInfo.appDescription);
            this.deployParams.setCategory(this.appInfo.category);
            this.deployParams.setLicenseType(this.appInfo.licenseType);
            this.deployParams.setCopyright(this.appInfo.copyright);
            for (Info.Icon i : this.appInfo.icons) {
                if (i instanceof Info.Splash) {
                    this.deployParams.addIcon(i.href, i.kind, i.width, i.height, i.depth, ((Info.Splash)i).mode);
                    continue;
                }
                this.deployParams.addIcon(i.href, i.kind, i.width, i.height, i.depth, DeployParams.RunMode.WEBSTART);
            }
        }
        this.deployParams.setUpdateMode(this.updateMode);
        this.deployParams.setExtension(this.isExtension);
        this.deployParams.setIncludeDT(this.includeDT);
        if (this.platform != null) {
            Platform pl = this.platform.get();
            if (pl.j2se != null) {
                this.deployParams.setJRE(pl.j2se);
            }
            if (pl.javafx != null) {
                this.deployParams.setJavafx(pl.javafx);
            }
            if (pl.javaRoot != null) {
                if ("".equals(pl.javaRoot)) {
                    this.deployParams.setJavaRuntimeSource(null);
                } else {
                    this.deployParams.setJavaRuntimeSource(new File(pl.javaRoot));
                }
            }
            for (Platform.Property p : pl.properties) {
                this.deployParams.addJvmProperty(p.name, p.value);
            }
            for (Platform.Jvmarg a : pl.jvmargs) {
                this.deployParams.addJvmArg(a.value);
            }
        }
        if (this.callbacks != null) {
            this.deployParams.setCallbacks(this.callbacks.callbacks);
        }
        if (this.prefs != null) {
            this.deployParams.setNeedShortcut(this.prefs.getShortcut());
            this.deployParams.setNeedInstall(this.prefs.getInstall());
            this.deployParams.setNeedMenu(this.prefs.getMenu());
            this.deployParams.setSystemWide(this.prefs.getSystemInstall());
        }
        for (Template t : this.templateList) {
            this.deployParams.addTemplate(t.infile, t.outfile);
        }
        this.deployParams.setPlaceholder(this.placeholder);
        for (FileSet fs : this.resources.getResources()) {
            Utils.addResources(this.deployParams, fs);
        }
        this.deployParams.setBundleType(this.nativeBundles);
        this.deployParams.setTargetFormat(this.bundleFormat);
        Log.setLogger(new AntLog(this.getProject()));
        try {
            this.packager.generateDeploymentPackages(this.deployParams);
        }
        catch (PackagerException pe) {
            throw new BuildException(pe.getCause().getMessage(), pe.getCause());
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        finally {
            Log.setLogger(null);
        }
    }

    public void setExtension(boolean v) {
        this.isExtension = v;
    }

    public void setNativeBundles(String v) {
        if ("false".equals(v) || "none".equals(v)) {
            this.nativeBundles = Bundler.BundleType.NONE;
        } else if ("all".equals(v) || "true".equals(v)) {
            this.nativeBundles = Bundler.BundleType.ALL;
        } else if ("image".equals(v)) {
            this.nativeBundles = Bundler.BundleType.IMAGE;
        } else if ("installer".equals(v)) {
            this.nativeBundles = Bundler.BundleType.INSTALLER;
        } else {
            this.nativeBundles = Bundler.BundleType.INSTALLER;
            this.bundleFormat = v != null ? v.toLowerCase() : null;
        }
    }

    public void setUpdateMode(String v) {
        String l = v.toLowerCase();
        if ("eager".equals(l)) {
            l = "always";
        }
        if (!("always".equals(l) || "background".equals(l) || "timeout".equals(l))) {
            throw new BuildException("Unknown update mode: [" + l + "]." + "Supported modes are: 'always', 'timeout' and 'background'");
        }
        this.updateMode = l;
    }

    public void setOfflineAllowed(boolean v) {
        this.offlineAllowed = v;
    }

    public void setEmbeddedWidth(String w) {
        this.embeddedWidth = w;
    }

    public void setWidth(String v) {
        this.width = v;
    }

    public void setEmbeddedHeight(String w) {
        this.embeddedHeight = w;
    }

    public void setHeight(String v) {
        this.height = v;
    }

    public void setEmbedJNLP(boolean v) {
        this.embedJNLP = v;
    }

    public void setOutdir(String v) {
        this.outdir = v;
    }

    public void setOutfile(String v) {
        this.outfile = v;
    }

    public void setIncludeDT(Boolean v) {
        this.includeDT = v;
    }

    public void setPlaceholderRef(String p) {
        this.placeholder = p;
    }

    public void setPlaceholderId(String id) {
        this.placeholder = "'" + id + "'";
    }

    public Info createInfo() {
        this.appInfo = new Info();
        return this.appInfo;
    }

    public Application createApplication() {
        this.app = new Application();
        return this.app;
    }

    public Preferences createPreferences() {
        this.prefs = new Preferences();
        return this.prefs;
    }

    public Callbacks createCallbacks() {
        if (this.callbacks != null) {
            throw new BuildException("Only one callbacks element is supported.");
        }
        this.callbacks = new Callbacks();
        return this.callbacks;
    }

    public Resources createResources() {
        if (this.resources != null) {
            throw new BuildException("Only one resources element is supported.");
        }
        this.resources = new Resources();
        return this.resources;
    }

    public Template createTemplate() {
        Template t = new Template();
        this.templateList.add(t);
        return t;
    }

    public Platform createPlatform() {
        this.platform = new Platform();
        return this.platform;
    }

    public Permissions createPermissions() {
        this.perms = new Permissions();
        return this.perms;
    }

    public static class Template
    extends DataType {
        File infile = null;
        File outfile = null;

        public void setFile(File f) {
            this.infile = f;
        }

        public void setTofile(File f) {
            this.outfile = f;
        }
    }

    public static class Permissions
    extends DataType {
        boolean embed = false;
        boolean elevated = true;

        public void setElevated(boolean v) {
            this.elevated = v;
        }

        public void setCacheCertificates(boolean v) {
            this.embed = v;
        }
    }
}

