/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.spring.rsf;

import java.util.Map;
import net.hasor.core.AppContext;
import net.hasor.core.Provider;
import net.hasor.plugins.spring.SpringModule;
import net.hasor.rsf.RsfClient;
import net.hasor.rsf.RsfContext;
import net.hasor.rsf.RsfFilter;
import net.hasor.rsf.RsfPublisher;
import net.hasor.rsf.RsfSettings;
import net.hasor.utils.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractRsfBean
implements FactoryBean,
ApplicationContextAware {
    private String factoryID = null;
    private String bindGroup = null;
    private String bindName = null;
    private String bindVersion = null;
    private Class<?> bindType = null;
    private String bindDesc = null;
    private int clientTimeout = 0;
    private String serializeType = null;
    private boolean onShadow = false;
    private Map<String, RsfFilter> filters = null;
    private ApplicationContext springContext;
    private RsfContext rsfContext;
    private RsfClient rsfClient;

    public Class getObjectType() {
        return this.getBindType();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.springContext = applicationContext;
    }

    public String getFactoryID() {
        return this.factoryID;
    }

    public void setFactoryID(String factoryID) {
        this.factoryID = factoryID;
    }

    public String getBindGroup() {
        return this.bindGroup;
    }

    public void setBindGroup(String bindGroup) {
        this.bindGroup = bindGroup;
    }

    public String getBindName() {
        return this.bindName;
    }

    public void setBindName(String bindName) {
        this.bindName = bindName;
    }

    public String getBindVersion() {
        return this.bindVersion;
    }

    public void setBindVersion(String bindVersion) {
        this.bindVersion = bindVersion;
    }

    public Class<?> getBindType() {
        return this.bindType;
    }

    public void setBindType(Class<?> bindType) {
        this.bindType = bindType;
    }

    public String getBindDesc() {
        return this.bindDesc;
    }

    public void setBindDesc(String bindDesc) {
        this.bindDesc = bindDesc;
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public void setClientTimeout(int clientTimeout) {
        this.clientTimeout = clientTimeout;
    }

    public String getSerializeType() {
        return this.serializeType;
    }

    public void setSerializeType(String serializeType) {
        this.serializeType = serializeType;
    }

    public boolean isOnShadow() {
        return this.onShadow;
    }

    public void setOnShadow(boolean onShadow) {
        this.onShadow = onShadow;
    }

    public Map<String, RsfFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, RsfFilter> filters) {
        this.filters = filters;
    }

    protected ApplicationContext getSpring() {
        return this.springContext;
    }

    protected RsfContext getRsfContext() {
        return this.rsfContext;
    }

    protected RsfClient getRsfClient() {
        return this.rsfClient;
    }

    public void init() throws Exception {
        RsfPublisher.LinkedBuilder likeBuilder;
        String factoryID;
        AppContext hasorContext;
        if (StringUtils.isBlank((String)this.getFactoryID())) {
            this.setFactoryID(SpringModule.DefaultHasorBeanName);
        }
        if ((hasorContext = (AppContext)this.springContext.getBean(factoryID = this.getFactoryID())) == null) {
            throw new NullPointerException("AppContext is null. of beanID '" + factoryID + "'");
        }
        this.rsfContext = (RsfContext)hasorContext.getInstance(RsfContext.class);
        if (this.rsfContext == null) {
            throw new NullPointerException("RsfContext is null.");
        }
        if (this.getBindType() == null) {
            throw new NullPointerException("bindType is null.");
        }
        this.loadDefaultValues();
        RsfPublisher publisher = this.rsfContext.publisher();
        RsfPublisher.LinkedBuilder configBuilder = likeBuilder = publisher.rsfService(this.getBindType());
        if (this instanceof Provider) {
            configBuilder = likeBuilder.toProvider((Provider)this);
        }
        configBuilder = configBuilder.group(this.getBindGroup()).name(this.getBindName()).version(this.getBindVersion()).timeout(this.getClientTimeout()).serialize(this.getSerializeType());
        Map<String, RsfFilter> filters = this.getFilters();
        RsfPublisher.LinkedBuilder filterBuilder = configBuilder;
        if (filters != null && !filters.isEmpty()) {
            for (Map.Entry<String, RsfFilter> rsfFilter : filters.entrySet()) {
                String key = rsfFilter.getKey();
                RsfFilter filter = rsfFilter.getValue();
                filterBuilder = filterBuilder.bindFilter(key, filter);
            }
        }
        RsfPublisher.LinkedBuilder builder = filterBuilder;
        if (this.isOnShadow()) {
            builder = builder.asShadow();
        }
        this.rsfClient = this.rsfContext.getRsfClient();
        RsfPublisher.RegisterBuilder<?> registerBuilder = this.configService((RsfPublisher.RegisterBuilder<?>)builder);
        registerBuilder.register();
    }

    protected void loadDefaultValues() {
        RsfSettings settings = this.rsfContext.getSettings();
        if (StringUtils.isBlank((String)this.bindGroup)) {
            this.bindGroup = settings.getDefaultGroup();
        }
        if (StringUtils.isBlank((String)this.bindName)) {
            this.bindName = this.getBindType().getName();
        }
        if (StringUtils.isBlank((String)this.bindVersion)) {
            this.bindVersion = settings.getDefaultVersion();
        }
        if (this.clientTimeout <= 0) {
            this.clientTimeout = settings.getDefaultTimeout();
        }
        if (StringUtils.isBlank((String)this.serializeType)) {
            this.serializeType = settings.getDefaultSerializeType();
        }
    }

    protected abstract RsfPublisher.RegisterBuilder<?> configService(RsfPublisher.RegisterBuilder<?> var1);
}

