/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.spring.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.hasor.plugins.spring.SpringModule;
import net.hasor.plugins.spring.factory.SpringFactoryBean;
import net.hasor.plugins.spring.parser.AbstractHasorDefinitionParser;
import net.hasor.plugins.spring.rsf.RsfAddressPropertyEditor;
import net.hasor.rsf.InterAddress;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.SpringVersion;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class HasorDefinitionParser
extends AbstractHasorDefinitionParser {
    HasorDefinitionParser() {
    }

    @Override
    protected String beanID(Element element, NamedNodeMap attributes) {
        String beanID = this.revertProperty(attributes, "factoryID");
        if (StringUtils.isBlank((String)beanID)) {
            beanID = SpringModule.DefaultHasorBeanName;
        }
        return beanID;
    }

    @Override
    protected AbstractBeanDefinition parse(Element element, NamedNodeMap attributes, ParserContext parserContext) {
        try {
            this.parsePropertyEditor(parserContext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        builder.getRawBeanDefinition().setBeanClass(SpringFactoryBean.class);
        builder.setAutowireMode(4);
        builder.setScope("singleton");
        builder.setLazyInit(true);
        String shareEvent = this.revertProperty(attributes, "shareEvent");
        if (StringUtils.isNotBlank((String)shareEvent)) {
            builder.addPropertyValue("shareEvent", (Object)Boolean.parseBoolean(shareEvent));
        }
        String startWith = this.revertProperty(attributes, "startWith");
        String startWithRef = this.revertProperty(attributes, "startWithRef");
        if (StringUtils.isNotBlank((String)startWith) || StringUtils.isNotBlank((String)startWithRef)) {
            ManagedList list = new ManagedList();
            list.setSource(ArrayList.class);
            list.setMergeEnabled(false);
            builder.addPropertyValue("modules", (Object)list);
            if (StringUtils.isNotBlank((String)startWithRef)) {
                String[] refs;
                for (String refName : refs = startWithRef.split(",")) {
                    list.add((Object)new RuntimeBeanReference(refName));
                }
            } else {
                BeanDefinitionBuilder startWithBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)startWith);
                startWithBuilder.setAutowireMode(4);
                AbstractBeanDefinition startWithDefine = startWithBuilder.getBeanDefinition();
                String beanName = new DefaultBeanNameGenerator().generateBeanName((BeanDefinition)startWithDefine, parserContext.getRegistry());
                list.add((Object)new BeanDefinitionHolder((BeanDefinition)startWithDefine, beanName));
            }
        }
        String refPropertiesBean = this.revertProperty(attributes, "refProperties");
        builder.addPropertyValue("refProperties", (Object)refPropertiesBean);
        HashMap<String, String> envMap = new HashMap<String, String>();
        builder.addPropertyValue("envConfig", envMap);
        String configFile = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element entry = (Element)node;
                if (entry.getLocalName().equals("configFile")) {
                    configFile = entry.getFirstChild().getNodeValue();
                    if (StringUtils.isBlank((String)configFile)) {
                        configFile = node.getNodeValue();
                    }
                } else if (entry.getLocalName().equals("property")) {
                    String key = entry.getAttribute("name");
                    if (StringUtils.isBlank((String)key)) continue;
                    envMap.put(key, entry.getTextContent());
                }
            }
            node = node.getNextSibling();
        }
        if (StringUtils.isNotBlank(configFile)) {
            builder.addPropertyValue("config", configFile);
        }
        return builder.getBeanDefinition();
    }

    private void parsePropertyEditor(ParserContext parserContext) throws IOException {
        if (ResourcesUtils.getResourceAsStream((String)("net.hasor.rsf.InterAddress".replace('.', '/') + ".class")) == null) {
            return;
        }
        String version = SpringVersion.getVersion();
        version = StringUtils.isBlank((String)version) ? "?" : version;
        HashMap<Object, Object> customEditors = null;
        if (version.charAt(0) == '4' || version.charAt(0) == '5') {
            customEditors = new HashMap<Object, Object>();
            customEditors.put(InterAddress.class, RsfAddressPropertyEditor.class);
        } else {
            customEditors = new HashMap();
            customEditors.put("net.hasor.rsf.InterAddress", new RsfAddressPropertyEditor());
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        builder.getRawBeanDefinition().setBeanClass(CustomEditorConfigurer.class);
        builder.setScope("singleton");
        builder.addPropertyValue("customEditors", customEditors);
        AbstractBeanDefinition propEditors = builder.getBeanDefinition();
        String beanID = RsfAddressPropertyEditor.class.getName();
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)propEditors, beanID);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(holder));
    }
}

