/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.spring.factory;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.AppContextWarp;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.core.Provider;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderSupport;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.context.WebApplicationContext;

public class SpringFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware,
Module,
Provider<AppContext> {
    protected static Logger logger = LoggerFactory.getLogger(Hasor.class);
    private AppContextWarp warpThis = new AppContextWarp((Provider)this);
    private AppContext realAppContext = null;
    private ApplicationContext applicationContext = null;
    private String config = null;
    private String refProperties = null;
    private Map<String, String> envConfig = null;
    private ArrayList<Module> modules = null;

    public final void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Map<String, String> getEnvConfig() {
        return this.envConfig;
    }

    public void setEnvConfig(Map<String, String> envConfig) {
        this.envConfig = envConfig;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getRefProperties() {
        return this.refProperties;
    }

    public void setRefProperties(String refProperties) {
        this.refProperties = refProperties;
    }

    public ArrayList<Module> getModules() {
        return this.modules;
    }

    public void setModules(ArrayList<Module> modules) {
        this.modules = modules;
    }

    public final Object getObject() throws Exception {
        return this.warpThis;
    }

    public final AppContext get() {
        if (this.realAppContext == null) {
            throw new IllegalStateException("has not been initialized");
        }
        return this.realAppContext;
    }

    public final Class<?> getObjectType() {
        return AppContext.class;
    }

    public final boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws Exception {
        Object obj;
        ArrayList<Object> moduleList = this.getModules();
        String config = this.getConfig();
        if (!StringUtils.isBlank((String)config)) {
            config = SystemPropertyUtils.resolvePlaceholders((String)config);
        }
        if (moduleList == null) {
            moduleList = new ArrayList();
        }
        moduleList.add(this);
        Module[] moduleArrays = moduleList.toArray(new Module[moduleList.size()]);
        Resource resource = null;
        if (StringUtils.isNotBlank((String)config)) {
            resource = this.applicationContext.getResource(config);
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.refProperties) && this.applicationContext.containsBean(this.refProperties) && (obj = this.applicationContext.getBean(this.refProperties)) instanceof PropertiesLoaderSupport) {
            PropertiesLoaderSupport envProperties = (PropertiesLoaderSupport)obj;
            Properties props = null;
            try {
                Method mergeProperties = PropertiesLoaderSupport.class.getDeclaredMethod("mergeProperties", new Class[0]);
                Method convertProperties = PropertyResourceConfigurer.class.getDeclaredMethod("convertProperties", Properties.class);
                mergeProperties.setAccessible(true);
                convertProperties.setAccessible(true);
                props = (Properties)mergeProperties.invoke((Object)envProperties, new Object[0]);
                convertProperties.invoke((Object)envProperties, props);
            }
            catch (Exception e) {
                logger.error("import environment variables error -> " + e.getMessage(), (Throwable)e);
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
            if (props == null) {
                logger.warn("not import any environment variables -> form Spring mergeProperties is null");
            } else {
                for (String keyStr : props.stringPropertyNames()) {
                    String keyVal = props.getProperty(keyStr);
                    envMap.put(keyStr, keyVal);
                }
            }
        }
        if (this.envConfig != null) {
            envMap.putAll(this.envConfig);
        }
        this.realAppContext = this.createAppContext(this.applicationContext, resource, envMap, moduleArrays);
    }

    public final void destroy() throws Exception {
        if (this.realAppContext != null) {
            this.realAppContext.shutdown();
        }
    }

    protected AppContext createAppContext(ApplicationContext context, Resource resource, Map<String, String> envProperties, Module ... modules) throws Exception {
        boolean testSupportWeb;
        HashMap hashMap = envProperties = envProperties == null ? new HashMap() : envProperties;
        if (envProperties.isEmpty()) {
            logger.info("not import any environment variables -> refProperties is null");
        } else {
            logger.info("import environment variables ,done. -> import size :" + envProperties.size());
        }
        boolean bl = testSupportWeb = ResourcesUtils.getResourceAsStream((String)"/org/springframework/web/context/WebApplicationContext.class") != null;
        if (testSupportWeb) {
            testSupportWeb = context instanceof WebApplicationContext;
        }
        URI mainSettings = resource == null ? null : resource.getURI();
        ClassLoader loader = context.getClassLoader();
        AppContext appContext = null;
        if (testSupportWeb) {
            ServletContext sc = ((WebApplicationContext)context).getServletContext();
            appContext = Hasor.create((Object)sc).setMainSettings(mainSettings).setLoader(loader).putAllData(envProperties).build(modules);
        } else {
            appContext = Hasor.create().setMainSettings(mainSettings).setLoader(loader).putAllData(envProperties).build(modules);
        }
        logger.info("create AppContext ,mainSettings = {} , modules = {}", (Object)mainSettings, (Object)modules);
        return appContext;
    }

    public void loadModule(ApiBinder apiBinder) throws Throwable {
        logger.info("hasor Spring factory init.");
    }
}

