/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.spring.factory;

import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.Provider;
import net.hasor.utils.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class HasorBean<T>
implements FactoryBean,
InitializingBean {
    private AppContext factory = null;
    private Provider<? extends T> beanProvider = null;
    private BindInfo<? extends T> beanBindInfo = null;
    private String refID = null;
    private Class<? extends T> refType = null;
    private String refName = null;

    public AppContext getFactory() {
        return this.factory;
    }

    public void setFactory(AppContext factory) {
        this.factory = factory;
    }

    public Class<? extends T> getRefType() {
        return this.refType;
    }

    public void setRefType(Class<? extends T> refType) {
        this.refType = refType;
    }

    public String getRefName() {
        return this.refName;
    }

    public void setRefName(String refName) {
        this.refName = refName;
    }

    public String getRefID() {
        return this.refID;
    }

    public void setRefID(String refID) {
        this.refID = refID;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.factory == null) {
            throw new NullPointerException("AppContext is null.");
        }
        if (StringUtils.isNotBlank((String)this.refID)) {
            this.beanBindInfo = this.factory.getBindInfo(this.refID);
        } else if (this.refName != null && this.refType != null) {
            this.beanBindInfo = this.factory.findBindingRegister(this.refName, this.refType);
        }
        if (this.beanBindInfo == null && this.refType == null) {
            throw new NullPointerException("HasorBean class is null.");
        }
        if (this.beanBindInfo != null) {
            this.beanProvider = this.factory.getProvider(this.beanBindInfo);
        }
    }

    public final Object getObject() throws Exception {
        if (this.beanProvider != null) {
            return this.beanProvider.get();
        }
        if (this.refType != null) {
            return this.factory.getInstance(this.refType);
        }
        throw new IllegalStateException("has not been initialized");
    }

    public final Class<?> getObjectType() {
        if (this.refType == null) {
            if (this.beanBindInfo == null) {
                throw new IllegalStateException("has not been initialized");
            }
            return this.beanBindInfo.getBindType();
        }
        return this.refType;
    }

    public final boolean isSingleton() {
        return false;
    }
}

