/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.spring;

import java.util.ArrayList;
import java.util.List;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.Module;
import net.hasor.core.Provider;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.plugins.spring.SpringBean;
import net.hasor.utils.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringModule
implements Module {
    public static final String DefaultHasorBeanName = AppContext.class.getName();
    private Provider<ApplicationContext> applicationContext;

    public SpringModule(ApplicationContext applicationContext) {
        this.applicationContext = new InstanceProvider((Object)applicationContext);
    }

    public SpringModule(Provider<ApplicationContext> applicationContext) {
        this.applicationContext = applicationContext;
    }

    public final void loadModule(ApiBinder apiBinder) throws Throwable {
        apiBinder.bindType(ApplicationContext.class).toProvider(this.applicationContext);
        ApplicationContext app = (ApplicationContext)this.applicationContext.get();
        String[] names = app.getBeanDefinitionNames();
        List<String> exportList = new ArrayList<String>();
        if (names != null) {
            for (String name : names) {
                if (!this.isExportBean(name)) continue;
                exportList.add(name);
            }
        }
        if ((exportList = this.exportBeanNames(exportList)) != null) {
            for (String name : exportList) {
                String className;
                if (!app.containsBean(name)) continue;
                Class beanType = Object.class;
                if (app instanceof ConfigurableApplicationContext && StringUtils.isNotBlank((String)(className = ((ConfigurableApplicationContext)app).getBeanFactory().getBeanDefinition(name).getBeanClassName()))) {
                    beanType = app.getClassLoader().loadClass(className);
                }
                apiBinder.bindType(beanType).idWith(name).toProvider(new SpringBean(name, this.applicationContext));
            }
        }
    }

    public Provider<ApplicationContext> getApplicationContextProvider() {
        return this.applicationContext;
    }

    protected boolean isExportBean(String beanName) {
        return false;
    }

    protected List<String> exportBeanNames(List<String> exportList) {
        return exportList;
    }
}

