/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.rsf.trace;

import java.util.UUID;
import net.hasor.utils.StringUtils;
import org.slf4j.MDC;

public abstract class TraceUtil {
    public static final String KEY = "traceID";
    private static final ThreadLocal<String> TraceID = new ThreadLocal();

    public static String getTraceID() {
        if (StringUtils.isBlank((String)TraceID.get())) {
            TraceUtil.updateTraceID(UUID.randomUUID().toString().replace("-", ""));
        }
        return TraceID.get();
    }

    protected static void updateTraceID(String oldTreaceID) {
        TraceUtil.clearTraceID();
        TraceID.set(oldTreaceID);
        MDC.put((String)KEY, (String)oldTreaceID);
    }

    protected static void clearTraceID() {
        if (TraceID.get() != null) {
            TraceID.remove();
        }
        MDC.remove((String)KEY);
    }
}

