/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.rsf.trace;

import net.hasor.plugins.rsf.trace.TraceUtil;
import net.hasor.rsf.RsfFilter;
import net.hasor.rsf.RsfFilterChain;
import net.hasor.rsf.RsfRequest;
import net.hasor.rsf.RsfResponse;
import net.hasor.utils.StringUtils;

public class TraceFilter
implements RsfFilter {
    public void doFilter(RsfRequest request, RsfResponse response, RsfFilterChain chain) throws Throwable {
        String traceID = request.getOption("traceID");
        if (!StringUtils.isBlank((String)traceID)) {
            InnerTraceUtil.updateTraceID(traceID);
        } else {
            traceID = InnerTraceUtil.getTraceID();
        }
        request.addOption("traceID", traceID);
        response.addOption("traceID", traceID);
        chain.doFilter(request, response);
    }

    private static class InnerTraceUtil
    extends TraceUtil {
        private InnerTraceUtil() {
        }

        public static void updateTraceID(String oldTreaceID) {
            TraceUtil.updateTraceID(oldTreaceID);
        }
    }
}

