/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.render;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.utils.ClassUtils;
import net.hasor.web.RenderEngine;
import net.hasor.web.RenderInvoker;

public class JsonRender
implements RenderEngine {
    private JsonRenderEngine jsonRenderEngine;

    public void initEngine(AppContext appContext) throws Throwable {
        BindInfo bindInfo = appContext.getBindInfo(JsonRenderEngine.class);
        if (bindInfo == null) {
            ClassLoader classLoader = ClassUtils.getClassLoader((ClassLoader)appContext.getClassLoader());
            try {
                Class.forName("com.alibaba.fastjson.JSON", false, classLoader);
                this.jsonRenderEngine = new FastJsonRenderEngine();
            }
            catch (Exception e1) {
                try {
                    Class.forName("com.google.gson.Gson", false, classLoader);
                    this.jsonRenderEngine = new GsonRenderEngine();
                }
                catch (Exception e2) {
                    throw new ClassNotFoundException("Did not find any of the following set up (Fastjson\u3001Gson)");
                }
            }
        } else {
            this.jsonRenderEngine = (JsonRenderEngine)appContext.getInstance(bindInfo);
        }
    }

    public boolean exist(String template) throws IOException {
        return true;
    }

    public void process(RenderInvoker renderData, Writer writer) throws Throwable {
        Object data = renderData.get("resultData");
        this.jsonRenderEngine.writerJson(data, writer);
    }

    public static class GsonRenderEngine
    implements JsonRenderEngine {
        private Gson gson = new GsonBuilder().create();

        @Override
        public void writerJson(Object renderData, Writer writerTo) throws Throwable {
            JsonWriter jsonWriter = this.gson.newJsonWriter(writerTo);
            this.gson.toJson(renderData, renderData.getClass(), jsonWriter);
        }
    }

    public static class FastJsonRenderEngine
    implements JsonRenderEngine {
        @Override
        public void writerJson(Object renderData, Writer writerTo) throws Throwable {
            JSON.writeJSONString((Writer)writerTo, (Object)renderData, (SerializerFeature[])new SerializerFeature[0]);
        }
    }

    public static interface JsonRenderEngine {
        public void writerJson(Object var1, Writer var2) throws Throwable;
    }
}

