/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.mybatis3;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.core.Hasor;
import net.hasor.db.jdbc.ConnectionCallback;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.plugins.mybatis3.SqlExecutorOperations;
import net.hasor.plugins.mybatis3.SqlSessionCallback;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class SqlExecutorTemplate
extends JdbcTemplate
implements SqlExecutorOperations {
    private SqlSessionFactory sessionFactory;

    public SqlExecutorTemplate(SqlSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SqlExecutorTemplate(SqlSessionFactory sessionFactory, DataSource dataSource) {
        super(dataSource);
        this.sessionFactory = sessionFactory;
    }

    public SqlExecutorTemplate(SqlSessionFactory sessionFactory, Connection conn) {
        super(conn);
        this.sessionFactory = sessionFactory;
    }

    public SqlSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SqlSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public <T> T execute(final SqlSessionCallback<T> sessionCallback) throws SQLException {
        Hasor.assertIsNotNull(sessionCallback, (String)"Callback object must not be null");
        ConnectionCallback callBack = new ConnectionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T doInConnection(Connection con) throws SQLException {
                SqlSession sqlSession = SqlExecutorTemplate.this.sessionFactory.openSession(con);
                try {
                    Object result;
                    Object t = result = sessionCallback.doSqlSession(sqlSession);
                    return t;
                }
                finally {
                    if (sqlSession != null) {
                        sqlSession.close();
                    }
                }
            }
        };
        return (T)this.execute(callBack);
    }

    @Override
    public <T> T selectOne(final String statement) throws SQLException {
        return this.execute(new SqlSessionCallback<T>(){

            @Override
            public T doSqlSession(SqlSession sqlSession) {
                return sqlSession.selectOne(statement);
            }
        });
    }

    @Override
    public <T> T selectOne(final String statement, final Object parameter) throws SQLException {
        return this.execute(new SqlSessionCallback<T>(){

            @Override
            public T doSqlSession(SqlSession sqlSession) {
                return sqlSession.selectOne(statement, parameter);
            }
        });
    }

    @Override
    public <E> List<E> selectList(final String statement) throws SQLException {
        return (List)this.execute(new SqlSessionCallback<List<E>>(){

            @Override
            public List<E> doSqlSession(SqlSession sqlSession) {
                return sqlSession.selectList(statement);
            }
        });
    }

    @Override
    public <E> List<E> selectList(final String statement, final Object parameter) throws SQLException {
        return (List)this.execute(new SqlSessionCallback<List<E>>(){

            @Override
            public List<E> doSqlSession(SqlSession sqlSession) {
                return sqlSession.selectList(statement, parameter);
            }
        });
    }

    @Override
    public <E> List<E> selectList(final String statement, final Object parameter, final RowBounds rowBounds) throws SQLException {
        return (List)this.execute(new SqlSessionCallback<List<E>>(){

            @Override
            public List<E> doSqlSession(SqlSession sqlSession) {
                return sqlSession.selectList(statement, parameter, rowBounds);
            }
        });
    }

    @Override
    public <K, V> Map<K, V> selectMap(final String statement, final String mapKey) throws SQLException {
        return (Map)this.execute(new SqlSessionCallback<Map<K, V>>(){

            @Override
            public Map<K, V> doSqlSession(SqlSession sqlSession) {
                return sqlSession.selectMap(statement, mapKey);
            }
        });
    }

    @Override
    public <K, V> Map<K, V> selectMap(final String statement, final Object parameter, final String mapKey) throws SQLException {
        return (Map)this.execute(new SqlSessionCallback<Map<K, V>>(){

            @Override
            public Map<K, V> doSqlSession(SqlSession sqlSession) {
                return sqlSession.selectMap(statement, parameter, mapKey);
            }
        });
    }

    @Override
    public <K, V> Map<K, V> selectMap(final String statement, final Object parameter, final String mapKey, final RowBounds rowBounds) throws SQLException {
        return (Map)this.execute(new SqlSessionCallback<Map<K, V>>(){

            @Override
            public Map<K, V> doSqlSession(SqlSession sqlSession) {
                return sqlSession.selectMap(statement, parameter, mapKey, rowBounds);
            }
        });
    }

    @Override
    public int insertStatement(final String statement) throws SQLException {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doSqlSession(SqlSession sqlSession) {
                return sqlSession.insert(statement);
            }
        });
    }

    @Override
    public int insertStatement(final String statement, final Object parameter) throws SQLException {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doSqlSession(SqlSession sqlSession) {
                return sqlSession.insert(statement, parameter);
            }
        });
    }

    @Override
    public int updateStatement(final String statement) throws SQLException {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doSqlSession(SqlSession sqlSession) {
                return sqlSession.update(statement);
            }
        });
    }

    @Override
    public int updateStatement(final String statement, final Object parameter) throws SQLException {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doSqlSession(SqlSession sqlSession) {
                return sqlSession.update(statement, parameter);
            }
        });
    }

    @Override
    public int deleteStatement(final String statement) throws SQLException {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doSqlSession(SqlSession sqlSession) {
                return sqlSession.delete(statement);
            }
        });
    }

    @Override
    public int deleteStatement(final String statement, final Object parameter) throws SQLException {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doSqlSession(SqlSession sqlSession) {
                return sqlSession.delete(statement, parameter);
            }
        });
    }
}

