/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.mybatis3;

import java.io.IOException;
import java.io.Reader;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContextAware;
import net.hasor.core.BindInfo;
import net.hasor.core.Environment;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.core.Provider;
import net.hasor.core.provider.InfoAwareProvider;
import net.hasor.core.provider.InstanceProvider;
import net.hasor.core.provider.SingleProvider;
import net.hasor.plugins.mybatis3.SqlExecutorOperations;
import net.hasor.plugins.mybatis3.SqlExecutorTemplate;
import net.hasor.plugins.mybatis3.SqlExecutorTemplateProvider;
import net.hasor.utils.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisModule
implements Module {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String dataSourceID = null;
    private Provider<SqlSessionFactory> sessionFactory = null;

    public MyBatisModule(String sqlmapConfig) throws IOException {
        this(null, (Provider<SqlSessionFactory>)MyBatisModule.defaultSessionFactory(sqlmapConfig));
    }

    public MyBatisModule(SqlSessionFactory sessionFactory) {
        this(null, (Provider<SqlSessionFactory>)new InstanceProvider(Hasor.assertIsNotNull((Object)sessionFactory, (String)"sessionFactory is null.")));
    }

    public MyBatisModule(Provider<SqlSessionFactory> sessionFactory) {
        this(null, sessionFactory);
    }

    public MyBatisModule(String dataSourceID, String sqlmapConfig) throws IOException {
        this(dataSourceID, (Provider<SqlSessionFactory>)MyBatisModule.defaultSessionFactory(sqlmapConfig));
    }

    public MyBatisModule(String dataSourceID, SqlSessionFactory sessionFactory) {
        this(dataSourceID, (Provider<SqlSessionFactory>)new InstanceProvider(Hasor.assertIsNotNull((Object)sessionFactory, (String)"sessionFactory is null.")));
    }

    public MyBatisModule(String dataSourceID, Provider<SqlSessionFactory> sessionFactory) {
        this.dataSourceID = dataSourceID;
        this.sessionFactory = (Provider)Hasor.assertIsNotNull(sessionFactory, (String)"sessionFactory is null.");
    }

    private static SingleProvider<SqlSessionFactory> defaultSessionFactory(String sqlmapConfig) throws IOException {
        Hasor.assertIsNotNull((Object)sqlmapConfig, (String)"sqlmapConfig is null.");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        final Reader reader = (Reader)Hasor.assertIsNotNull((Object)Resources.getResourceAsReader((ClassLoader)loader, (String)sqlmapConfig), (String)("could not find resource '" + sqlmapConfig + "'"));
        return new SingleProvider((Provider)new Provider<SqlSessionFactory>(){

            public SqlSessionFactory get() {
                return new SqlSessionFactoryBuilder().build(reader);
            }
        });
    }

    public void loadModule(ApiBinder apiBinder) {
        if (StringUtils.isBlank((String)this.dataSourceID)) {
            BindInfo bindInfo = apiBinder.getBindInfo(DataSource.class);
            if (bindInfo == null) {
                throw new IllegalStateException("need DataSource.");
            }
            Provider dataSource = (Provider)Hasor.autoAware((Environment)apiBinder.getEnvironment(), (AppContextAware)new InfoAwareProvider(bindInfo));
            final SqlExecutorTemplateProvider templateProvider = new SqlExecutorTemplateProvider(this.sessionFactory, (Provider<DataSource>)dataSource);
            apiBinder.bindType(SqlExecutorTemplate.class).toProvider((Provider)templateProvider);
            apiBinder.bindType(SqlExecutorOperations.class).toProvider((Provider)new Provider<SqlExecutorOperations>(){

                public SqlExecutorOperations get() {
                    return templateProvider.get();
                }
            });
        } else {
            BindInfo bindInfo = apiBinder.findBindingRegister(this.dataSourceID, DataSource.class);
            if (bindInfo == null) {
                throw new IllegalStateException("need DataSource.");
            }
            Provider dataSource = (Provider)Hasor.autoAware((Environment)apiBinder.getEnvironment(), (AppContextAware)new InfoAwareProvider(bindInfo));
            final SqlExecutorTemplateProvider templateProvider = new SqlExecutorTemplateProvider(this.sessionFactory, (Provider<DataSource>)dataSource);
            apiBinder.bindType(SqlExecutorTemplate.class).nameWith(this.dataSourceID).toProvider((Provider)templateProvider);
            apiBinder.bindType(SqlExecutorOperations.class).nameWith(this.dataSourceID).toProvider((Provider)new Provider<SqlExecutorOperations>(){

                public SqlExecutorOperations get() {
                    return templateProvider.get();
                }
            });
        }
    }
}

