/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.plugins.junit.ContextConfiguration;
import net.hasor.plugins.junit.DaemonThread;
import net.hasor.plugins.junit.TestOrder;
import net.hasor.utils.BeanUtils;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasorUnitRunner
extends BlockJUnit4ClassRunner {
    protected static Logger logger = LoggerFactory.getLogger(HasorUnitRunner.class);
    private AppContext appContext = null;
    private BindInfo<?> typeRegister = null;

    public HasorUnitRunner(final Class<?> klass) throws InitializationError {
        super(klass);
        try {
            String configResource = "hasor-config.xml";
            ContextConfiguration config = klass.getAnnotation(ContextConfiguration.class);
            ArrayList<Module> loadModule = new ArrayList<Module>();
            if (config != null) {
                configResource = config.value();
                for (Class<? extends Module> mod : config.loadModules()) {
                    loadModule.add(mod.newInstance());
                }
            }
            loadModule.add(new Module(){

                public void loadModule(ApiBinder apiBinder) throws Throwable {
                    HasorUnitRunner.this.typeRegister = apiBinder.bindType(klass).uniqueName().toInfo();
                }
            });
            this.appContext = Hasor.createAppContext((String)configResource, (Module[])loadModule.toArray(new Module[loadModule.size()]));
            if (this.appContext == null) {
                throw new NullPointerException("HasorFactory.createAppContext return null.");
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new InitializationError((Throwable)e);
        }
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> toRunMethodList = super.computeTestMethods();
        for (FrameworkMethod method : toRunMethodList) {
            if (method.getAnnotation(DaemonThread.class) == null) continue;
            throw new IllegalStateException("test method cannot be used at the same time, @Test, @DaemonThread");
        }
        toRunMethodList = new ArrayList<FrameworkMethod>(toRunMethodList);
        Collections.sort(toRunMethodList, new Comparator<FrameworkMethod>(){

            @Override
            public int compare(FrameworkMethod m1, FrameworkMethod m2) {
                TestOrder o1 = (TestOrder)m1.getAnnotation(TestOrder.class);
                TestOrder o2 = (TestOrder)m2.getAnnotation(TestOrder.class);
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.value() - o2.value();
            }
        });
        return toRunMethodList;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        List methodList = this.getTestClass().getAnnotatedMethods(DaemonThread.class);
        final ArrayList<TestThread> daemonThreads = new ArrayList<TestThread>();
        for (FrameworkMethod threadMethod : methodList) {
            TestThread daemonThread = new TestThread(test, threadMethod);
            daemonThread.setDaemon(true);
            daemonThreads.add(daemonThread);
        }
        final Statement invokerStatement = super.methodInvoker(method, test);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    for (Thread thread : daemonThreads) {
                        thread.start();
                    }
                    invokerStatement.evaluate();
                }
                finally {
                    for (Thread thread : daemonThreads) {
                        thread.suspend();
                        thread.interrupt();
                    }
                }
            }
        };
    }

    protected Object createTest() throws Exception {
        Object testUnit = this.appContext.getInstance(this.typeRegister);
        return testUnit;
    }

    private static class TestThread
    extends Thread {
        private Object targetObject = null;
        private FrameworkMethod method = null;

        public TestThread(Object targetObject, FrameworkMethod method) {
            super("daemonThread:" + method.getName());
            this.targetObject = targetObject;
            this.method = method;
        }

        @Override
        public void run() {
            ArrayList<Object> args = new ArrayList<Object>();
            Class<?>[] params = this.method.getMethod().getParameterTypes();
            if (params != null) {
                for (Class<?> param : params) {
                    args.add(BeanUtils.getDefaultValue(param));
                }
            }
            try {
                this.method.invokeExplosively(this.targetObject, args.toArray());
            }
            catch (Throwable e) {
                logger.error("call invokeExplosively exception = {}.", e);
            }
        }
    }
}

