/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.junit;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;

public abstract class HasorUnit {
    public static String newID() {
        return UUID.randomUUID().toString();
    }

    public static <T> String printObjectList(List<T> dataList) {
        return HasorUnit.printObjectList(dataList, System.out);
    }

    public static String printMapList(List<Map<String, Object>> dataList) {
        return HasorUnit.printMapList(dataList, System.out);
    }

    public static <T> String printObjectList(List<T> dataList, PrintStream out) {
        ArrayList<Map<String, Object>> newDataList = new ArrayList<Map<String, Object>>();
        for (T obj : dataList) {
            List keys = BeanUtils.getPropertysAndFields(obj.getClass());
            HashMap<String, Object> newObj = new HashMap<String, Object>();
            for (String key : keys) {
                newObj.put(key, BeanUtils.readPropertyOrField(obj, (String)key));
            }
            newDataList.add(newObj);
        }
        return HasorUnit.printMapList(newDataList, out);
    }

    public static String printMapList(List<Map<String, Object>> dataList, PrintStream out) {
        ArrayList newValues = new ArrayList();
        LinkedHashMap<String, Integer> titleConfig = new LinkedHashMap<String, Integer>();
        for (Map<String, Object> mapItem : dataList) {
            HashMap<String, String> newVal = new HashMap<String, String>();
            for (Map.Entry entry : mapItem.entrySet()) {
                String key = (String)entry.getKey();
                String val = ConverterUtils.convert(entry.getValue());
                val = val == null ? "" : val;
                Integer maxTitleLength = (Integer)titleConfig.get(key);
                if (maxTitleLength == null) {
                    maxTitleLength = HasorUnit.stringLength(key);
                }
                if (val.length() > maxTitleLength) {
                    maxTitleLength = HasorUnit.stringLength(val);
                }
                titleConfig.put(key, maxTitleLength);
                newVal.put(key, val);
            }
            newValues.add(newVal);
        }
        StringBuffer output = new StringBuffer();
        boolean first = true;
        int titleLength = 0;
        for (Map map : newValues) {
            StringBuffer sb;
            if (first) {
                sb = new StringBuffer("");
                for (Map.Entry titleEnt : titleConfig.entrySet()) {
                    String title = StringUtils.rightPad((String)((String)titleEnt.getKey()), (int)((Integer)titleEnt.getValue()), (char)' ');
                    sb.append(String.format("| %s ", title));
                }
                sb.append("|");
                titleLength = sb.length();
                sb.insert(0, String.format("/%s\\\n", StringUtils.center((String)"", (int)(titleLength - 2), (String)"-")));
                first = false;
                output.append(sb + "\n");
                output.append(String.format("|%s|\n", StringUtils.center((String)"", (int)(titleLength - 2), (String)"-")));
            }
            sb = new StringBuffer("");
            for (String colKey : titleConfig.keySet()) {
                String val = (String)map.get(colKey);
                String valueStr = StringUtils.rightPad((String)val, (int)HasorUnit.fixLength(val, (Integer)titleConfig.get(colKey)), (char)' ');
                sb.append(String.format("| %s ", valueStr));
            }
            sb.append("|");
            output.append(sb.toString() + "\n");
        }
        output.append(String.format("\\%s/", StringUtils.center((String)"", (int)(titleLength - 2), (String)"-")));
        if (out != null) {
            out.println(output);
        }
        return output.toString();
    }

    private static int stringLength(String str) {
        int length = 0;
        for (char c : str.toCharArray()) {
            if (StringUtils.isAscii((char)c)) {
                ++length;
                continue;
            }
            length += 2;
        }
        return length;
    }

    private static int fixLength(String str, int length) {
        for (char c : str.toCharArray()) {
            if (StringUtils.isAscii((char)c)) continue;
            --length;
        }
        return length;
    }
}

