/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.jfinal;

import com.jfinal.core.JFinal;
import com.jfinal.kit.PropKit;
import com.jfinal.plugin.IPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContext;
import net.hasor.core.Environment;
import net.hasor.core.EventListener;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.core.Provider;
import net.hasor.plugins.jfinal.InnerFilterConfig;
import net.hasor.plugins.jfinal.InnerMap;
import net.hasor.utils.ExceptionUtils;
import net.hasor.web.startup.RuntimeFilter;
import net.hasor.web.startup.RuntimeListener;

public class HasorPlugin
implements IPlugin {
    private final JFinal jFinal;
    private AppContext appContext;
    private final RuntimeListener listener;
    private final RuntimeFilter rootFilter;

    public static AppContext getAppContext(JFinal jFinal) {
        return RuntimeListener.getAppContext((ServletContext)((JFinal)Hasor.assertIsNotNull((Object)jFinal, (String)"jFinal Context is null.")).getServletContext());
    }

    public HasorPlugin(JFinal jFinal) {
        this(jFinal, "hasor-config.xml", Collections.emptyList());
    }

    public HasorPlugin(JFinal jFinal, String mainSettings) {
        this(jFinal, mainSettings, Collections.emptyList());
    }

    public HasorPlugin(JFinal jFinal, Module ... modules) {
        this(jFinal, "hasor-config.xml", Arrays.asList(modules));
    }

    public HasorPlugin(JFinal jFinal, List<Module> moduleList) {
        this(jFinal, "hasor-config.xml", moduleList);
    }

    public HasorPlugin(JFinal jFinal, String mainSettings, Module ... modules) {
        this(jFinal, mainSettings, Arrays.asList(modules));
    }

    public HasorPlugin(final JFinal jFinal, final String mainSettings, final List<Module> moduleList) {
        this.jFinal = (JFinal)Hasor.assertIsNotNull((Object)jFinal, (String)"jFinal Context is null.");
        AppContext webAppContext = RuntimeListener.getAppContext((ServletContext)this.jFinal.getServletContext());
        if (webAppContext != null) {
            throw new IllegalStateException("Hasor AppContext already exists.");
        }
        this.listener = new RuntimeListener(){

            protected Hasor newHasor(ServletContext sc, String configName, Properties properties) throws Throwable {
                return HasorPlugin.this.newAppContext(jFinal, mainSettings, moduleList, properties);
            }
        };
        this.rootFilter = new RuntimeFilter();
    }

    public boolean start() {
        try {
            this.doStart();
            return true;
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    private void doStart() throws ServletException {
        this.listener.contextInitialized(new ServletContextEvent(this.jFinal.getServletContext()));
        this.appContext = RuntimeListener.getAppContext((ServletContext)this.jFinal.getServletContext());
        InnerMap envProp = (InnerMap)this.appContext.getInstance(InnerMap.class);
        this.rootFilter.init((FilterConfig)new InnerFilterConfig(this.jFinal, envProp));
        Hasor.pushShutdownListener((Environment)this.appContext.getEnvironment(), (EventListener)new EventListener<Object>(){

            public void onEvent(String event, Object eventData) throws Throwable {
                HasorPlugin.this.stop();
            }
        });
    }

    public boolean stop() {
        this.rootFilter.destroy();
        this.listener.contextDestroyed(new ServletContextEvent(this.jFinal.getServletContext()));
        return true;
    }

    protected Hasor newAppContext(final JFinal jFinal, String mainSettings, List<Module> moduleList, Properties properties) throws Throwable {
        InnerMap envProp = null;
        try {
            Properties jfProp = PropKit.getProp().getProperties();
            envProp = new InnerMap();
            if (jfProp != null) {
                for (Map.Entry<Object, Object> ent : jfProp.entrySet()) {
                    Object entKey = ent.getKey();
                    Object entValue = ent.getValue();
                    envProp.put(entKey.toString(), entValue.toString());
                }
            }
        }
        catch (IllegalStateException jfProp) {
            // empty catch block
        }
        final InnerMap finalEnvProp = envProp;
        return Hasor.create((Object)jFinal.getServletContext()).setMainSettings(mainSettings).putAllData((Map)envProp).addModules(moduleList).addModules(new Module[]{new Module(){

            public void loadModule(ApiBinder apiBinder) throws Throwable {
                apiBinder.bindType(InnerMap.class).toInstance((Object)(finalEnvProp != null ? finalEnvProp : new InnerMap()));
                apiBinder.bindType(JFinal.class).toInstance((Object)jFinal);
                apiBinder.bindType(RuntimeFilter.class).toProvider((Provider)new Provider<RuntimeFilter>(){

                    public RuntimeFilter get() {
                        return HasorPlugin.this.rootFilter;
                    }
                });
            }
        }});
    }
}

