/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.jfinal;

import com.jfinal.plugin.activerecord.IDataSourceProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.Module;
import net.hasor.db.JdbcModule;
import net.hasor.db.Level;
import net.hasor.db.transaction.TranManager;

public class HasorDataSourceProxy
implements IDataSourceProvider,
Module {
    private String name;
    private DataSource dataSourceProxy;

    public HasorDataSourceProxy(IDataSourceProvider iDataSourceProvider) {
        this(null, iDataSourceProvider);
    }

    public HasorDataSourceProxy(String name, IDataSourceProvider iDataSourceProvider) {
        this.name = name;
        this.dataSourceProxy = this.newProxyDataSource(iDataSourceProvider);
    }

    public DataSource getDataSource() {
        return this.dataSourceProxy;
    }

    public void loadModule(ApiBinder apiBinder) throws Throwable {
        apiBinder.installModule((Module)new JdbcModule(Level.Full, this.name, this.dataSourceProxy));
    }

    private DataSource newProxyDataSource(IDataSourceProvider iDataSourceProvider) {
        DataSourceInvocationHandler handler = new DataSourceInvocationHandler(iDataSourceProvider);
        return (DataSource)Proxy.newProxyInstance(DataSource.class.getClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)handler);
    }

    private class DataSourceInvocationHandler
    implements InvocationHandler {
        private IDataSourceProvider iDataSourceProvider;

        public DataSourceInvocationHandler(IDataSourceProvider iDataSourceProvider) {
            this.iDataSourceProvider = iDataSourceProvider;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getConnection")) {
                return TranManager.currentConnection((DataSource)this.iDataSourceProvider.getDataSource());
            }
            try {
                return method.invoke((Object)this.iDataSourceProvider.getDataSource(), args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

