/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.freemarker.render;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletContext;
import net.hasor.core.AppContext;
import net.hasor.core.BindInfo;
import net.hasor.core.Hasor;
import net.hasor.utils.StringUtils;
import net.hasor.web.RenderEngine;
import net.hasor.web.RenderInvoker;

public class FreemarkerRender
implements RenderEngine {
    protected Configuration freemarker;

    protected Configuration newConfiguration(AppContext appContext, ServletContext servletContext) throws IOException {
        String realPath = servletContext.getRealPath("/");
        FileTemplateLoader templateLoader = new FileTemplateLoader(new File(realPath), true);
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setTemplateLoader((TemplateLoader)templateLoader);
        String responseEncoding = (String)appContext.findBindingBean("HTTP_RESPONSE_ENCODING", String.class);
        if (StringUtils.isBlank((String)responseEncoding)) {
            responseEncoding = "UTF-8";
        }
        configuration.setDefaultEncoding(responseEncoding);
        configuration.setOutputEncoding(responseEncoding);
        configuration.setLocalizedLookup(false);
        configuration.setClassicCompatible(true);
        return configuration;
    }

    protected void configSharedVariable(AppContext appContext, ServletContext servletContext, Configuration freemarker) throws TemplateModelException {
        freemarker.setSharedVariable("stringUtils", (Object)new StringUtils());
        freemarker.setSharedVariable("ctx_path", (Object)servletContext.getContextPath());
    }

    public void initEngine(AppContext appContext) throws Throwable {
        ServletContext servletContext = (ServletContext)Hasor.assertIsNotNull((Object)appContext.getInstance(ServletContext.class));
        BindInfo bindInfo = appContext.getBindInfo(Configuration.class);
        this.freemarker = bindInfo == null ? this.newConfiguration(appContext, servletContext) : (Configuration)appContext.getInstance(bindInfo);
        this.configSharedVariable(appContext, servletContext, (Configuration)Hasor.assertIsNotNull((Object)this.freemarker));
    }

    public boolean exist(String template) throws IOException {
        return this.freemarker.getTemplateLoader().findTemplateSource(template) != null;
    }

    public void process(RenderInvoker renderData, Writer writer) throws Throwable {
        Template temp = this.freemarker.getTemplate(renderData.renderTo());
        if (temp == null) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (String key : renderData.keySet()) {
            data.put(key, renderData.get(key));
        }
        temp.process(data, writer);
    }
}

