/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.freemarker.loader;

import freemarker.cache.StatefulTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.hasor.plugins.freemarker.loader.ITemplateLoader;
import net.hasor.utils.resource.ResourceLoader;
import net.hasor.utils.resource.loader.MultiResourceLoader;

public class MultiTemplateLoader
implements ITemplateLoader,
StatefulTemplateLoader {
    private final MultiResourceLoader resourceLoader = new MultiResourceLoader();
    private final ArrayList<TemplateLoader> loaders = new ArrayList();
    private final Map<String, TemplateLoader> lastLoaderForName = Collections.synchronizedMap(new HashMap());

    public MultiTemplateLoader() {
        this(new TemplateLoader[0]);
    }

    public MultiTemplateLoader(TemplateLoader[] loaders) {
        for (int i = 0; i < loaders.length; ++i) {
            TemplateLoader loader = loaders[i];
            if (loader instanceof ResourceLoader) {
                this.resourceLoader.addResourceLoader((ResourceLoader)loader);
            }
            this.loaders.add(loader);
        }
    }

    @Override
    public String getType() {
        return this.getClass().getSimpleName();
    }

    public void addTemplateLoader(TemplateLoader loader) {
        if (!this.loaders.contains(loader)) {
            this.loaders.add(loader);
        }
    }

    public Object findTemplateSource(String name) throws IOException {
        Object source;
        TemplateLoader lastLoader = this.lastLoaderForName.get(name);
        if (lastLoader != null && (source = lastLoader.findTemplateSource(name)) != null) {
            return new MultiSource(source, lastLoader);
        }
        for (int i = 0; i < this.loaders.size(); ++i) {
            TemplateLoader loader = this.loaders.get(i);
            Object source2 = loader.findTemplateSource(name);
            if (source2 == null) continue;
            this.lastLoaderForName.put(name, loader);
            return new MultiSource(source2, loader);
        }
        this.lastLoaderForName.remove(name);
        return null;
    }

    public long getLastModified(Object templateSource) {
        return ((MultiSource)templateSource).getLastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return ((MultiSource)templateSource).getReader(encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((MultiSource)templateSource).close();
    }

    public void resetState() {
        this.lastLoaderForName.clear();
        for (int i = 0; i < this.loaders.size(); ++i) {
            TemplateLoader loader = this.loaders.get(i);
            if (!(loader instanceof StatefulTemplateLoader)) continue;
            ((StatefulTemplateLoader)loader).resetState();
        }
    }

    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        return this.resourceLoader.getResourceAsStream(resourcePath);
    }

    public URL getResource(String resourcePath) throws IOException {
        return this.resourceLoader.getResource(resourcePath);
    }

    private static final class MultiSource {
        private final Object source;
        private final TemplateLoader loader;

        MultiSource(Object source, TemplateLoader loader) {
            this.source = source;
            this.loader = loader;
        }

        long getLastModified() {
            return this.loader.getLastModified(this.source);
        }

        Reader getReader(String encoding) throws IOException {
            return this.loader.getReader(this.source, encoding);
        }

        void close() throws IOException {
            this.loader.closeTemplateSource(this.source);
        }

        public boolean equals(Object o) {
            if (o instanceof MultiSource) {
                MultiSource m = (MultiSource)o;
                return m.loader.equals(this.loader) && m.source.equals(this.source);
            }
            return false;
        }

        public int hashCode() {
            return this.loader.hashCode() + 31 * this.source.hashCode();
        }

        public String toString() {
            return this.source.toString();
        }
    }
}

