/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.freemarker.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.hasor.plugins.freemarker.loader.ITemplateLoader;
import net.hasor.plugins.freemarker.loader.mto.AbstractTemplateObject;
import net.hasor.plugins.freemarker.loader.mto.ClasspathTemplateObject;
import net.hasor.plugins.freemarker.loader.mto.FileTemplateObject;
import net.hasor.plugins.freemarker.loader.mto.StringTemplateObject;
import net.hasor.plugins.freemarker.loader.mto.URLTemplateObject;

public class ConfigTemplateLoader
implements ITemplateLoader {
    private Map<String, AbstractTemplateObject> objectMap = new HashMap<String, AbstractTemplateObject>();

    @Override
    public String getType() {
        return this.getClass().getSimpleName();
    }

    public void addTemplate(String name, String classPath) {
        this.objectMap.put(name, new ClasspathTemplateObject(classPath, Thread.currentThread().getContextClassLoader()));
    }

    public void addTemplate(String name, File filePath) {
        this.objectMap.put(name, new FileTemplateObject(filePath));
    }

    public void addTemplate(String name, URL urlPath) {
        this.objectMap.put(name, new URLTemplateObject(urlPath));
    }

    public void addTemplateAsString(String name, String templateString) {
        this.objectMap.put(name, new StringTemplateObject(templateString));
    }

    public Object findTemplateSource(String arg0) throws IOException {
        if (!this.objectMap.containsKey(arg0)) {
            return null;
        }
        return this.objectMap.get(arg0);
    }

    public long getLastModified(Object arg0) {
        AbstractTemplateObject mto = (AbstractTemplateObject)arg0;
        return mto.lastModified();
    }

    public Reader getReader(Object arg0, String encoding) throws IOException {
        if (!(arg0 instanceof AbstractTemplateObject)) {
            return null;
        }
        AbstractTemplateObject mto = (AbstractTemplateObject)arg0;
        mto.openObject();
        return mto.getReader(encoding);
    }

    public void closeTemplateSource(Object arg0) throws IOException {
        if (arg0 instanceof AbstractTemplateObject) {
            ((AbstractTemplateObject)arg0).closeObject();
        }
    }

    public URL getResource(String resourcePath) throws IOException {
        if (!this.objectMap.containsKey(resourcePath)) {
            return null;
        }
        return new URL("template-mto://" + resourcePath);
    }

    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        if (!this.objectMap.containsKey(resourcePath)) {
            return null;
        }
        return this.objectMap.get(resourcePath).getInputStream();
    }

    public void resetState() {
        this.objectMap.clear();
    }
}

