/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.plugins.freemarker.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import net.hasor.plugins.freemarker.loader.ITemplateLoader;
import net.hasor.utils.resource.loader.ClassPathResourceLoader;

public class ClasspathTemplateLoader
extends URLClassLoader
implements ITemplateLoader {
    private String packageName = null;
    private ClassPathResourceLoader resourceLoader = null;

    public ClasspathTemplateLoader() {
        this("", Thread.currentThread().getContextClassLoader());
    }

    public ClasspathTemplateLoader(String packageName) {
        this(packageName, Thread.currentThread().getContextClassLoader());
    }

    public ClasspathTemplateLoader(String packageName, ClassLoader parent) {
        super(new URL[0], parent);
        this.packageName = packageName == null ? "" : packageName;
        this.packageName = this.packageName.replace(".", "/");
        if (this.packageName.length() > 0 && this.packageName.charAt(0) == '/') {
            this.packageName = this.packageName.substring(1);
        }
        this.resourceLoader = new ClassPathResourceLoader(this.packageName, (ClassLoader)this);
    }

    @Override
    public String getType() {
        return this.getClass().getSimpleName();
    }

    public Object findTemplateSource(String name) throws IOException {
        StringBuffer $name = new StringBuffer(this.packageName);
        if (name.charAt(0) != '/') {
            $name.append("/");
        }
        $name.append(name);
        if ($name.charAt(0) == '/') {
            $name = $name.deleteCharAt(0);
        }
        return this.getResource($name.toString());
    }

    public long getLastModified(Object templateSource) {
        URL url = (URL)templateSource;
        if (url.getProtocol().equals("file")) {
            return new File(url.getFile()).lastModified();
        }
        return 0L;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        URL url = (URL)templateSource;
        InputStream in = url.openStream();
        if (encoding == null) {
            return new InputStreamReader(in);
        }
        return new InputStreamReader(in, encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.resourceLoader.getResourceAsStream(name);
    }
}

