/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.resource.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.hasor.utils.resource.ResourceLoader;

public class PathResourceLoader
implements ResourceLoader {
    private String dirPath = null;

    public PathResourceLoader(String dirPath) {
        this.dirPath = dirPath;
    }

    private String formatResourcePath(String resourcePath) {
        String $resourcePath = this.dirPath + "/" + resourcePath;
        $resourcePath = $resourcePath.replaceAll("/{2}", "/");
        return $resourcePath;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        File file = new File(resourcePath = this.formatResourcePath(resourcePath));
        if (file.exists() && file.isFile()) {
            return new FileInputStream(file);
        }
        return null;
    }

    @Override
    public boolean exist(String resourcePath) {
        File file = new File(resourcePath = this.formatResourcePath(resourcePath));
        return file.exists() && file.isFile();
    }

    @Override
    public long getResourceSize(String resourcePath) {
        File file = new File(resourcePath = this.formatResourcePath(resourcePath));
        if (file.isFile()) {
            return file.length();
        }
        return -1L;
    }

    @Override
    public URL getResource(String resourcePath) throws IOException {
        File file = new File(resourcePath);
        if (file.exists() && file.isFile()) {
            return file.toURI().toURL();
        }
        return null;
    }
}

