/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

public class MatchUtils {
    public static String wildToRegex(String wild) {
        if (wild == null) {
            throw new NullPointerException("wild param is null");
        }
        StringBuffer result = new StringBuffer("");
        char[] metachar = new char[]{'$', '^', '[', ']', '(', ')', '{', '|', '+', '.', '\\'};
        for (int i = 0; i < wild.length(); ++i) {
            char ch = wild.charAt(i);
            for (char element : metachar) {
                if (ch != element) continue;
                result.append("\\");
            }
            if (ch == '*') {
                result.append(".*");
                continue;
            }
            if (ch == '?') {
                result.append(".");
                continue;
            }
            result.append(ch);
        }
        result.append("$");
        return result.toString();
    }

    public static boolean matchWild(String pattern, String str) {
        if (str == null) {
            return false;
        }
        return str.matches(MatchUtils.wildToRegex(pattern));
    }

    public static boolean wildToRegex(String pattern, String str, MatchTypeEnum matchType) {
        if (MatchTypeEnum.Regex == matchType) {
            return str.matches(pattern);
        }
        if (MatchTypeEnum.Wild == matchType) {
            return MatchUtils.matchWild(pattern, str);
        }
        return false;
    }

    public static enum MatchTypeEnum {
        Wild,
        Regex;

    }
}

