/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.hasor.utils.resource.ResourceLoader;

public class MultiResourceLoader
implements ResourceLoader {
    private final List<ResourceLoader> loaders = new CopyOnWriteArrayList<ResourceLoader>();
    private final ConcurrentMap<String, ResourceLoader> lastLoaderForName = new ConcurrentHashMap<String, ResourceLoader>();

    public MultiResourceLoader() {
        this(new ResourceLoader[0]);
    }

    public MultiResourceLoader(ResourceLoader[] loaders) {
        for (int i = 0; i < loaders.length; ++i) {
            this.loaders.add(loaders[i]);
        }
    }

    public void addResourceLoader(ResourceLoader loader) {
        if (!this.loaders.contains(loader)) {
            this.loaders.add(loader);
        }
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        ResourceLoader loader = this.findLoader(resourcePath);
        if (loader != null) {
            InputStream inStream = loader.getResourceAsStream(resourcePath);
            return inStream;
        }
        return null;
    }

    protected ResourceLoader findLoader(String resourcePath) throws IOException {
        ResourceLoader loader = (ResourceLoader)this.lastLoaderForName.get(resourcePath);
        if (loader == null) {
            for (ResourceLoader loads : this.loaders) {
                if (loads == null || !loads.exist(resourcePath) || (loader = this.lastLoaderForName.putIfAbsent(resourcePath, loads)) != null) continue;
                loader = loads;
            }
        }
        return loader;
    }

    @Override
    public boolean exist(String resourcePath) throws IOException {
        return this.findLoader(resourcePath) != null;
    }

    @Override
    public URL getResource(String resourcePath) throws IOException {
        ResourceLoader loader = this.findLoader(resourcePath);
        if (loader != null) {
            return loader.getResource(resourcePath);
        }
        return null;
    }
}

