/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.hasor.utils.StringUtils;
import net.hasor.utils.resource.ResourceLoader;

public class ClassPathResourceLoader
implements ResourceLoader {
    private String packageName = null;
    private ClassLoader classLoader = null;

    public ClassPathResourceLoader(String packageName) {
        this.packageName = packageName;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ClassPathResourceLoader(String packageName, ClassLoader classLoader) {
        this.packageName = packageName;
        this.classLoader = classLoader;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private String formatResourcePath(String resourcePath) {
        String path = this.packageName + (resourcePath.charAt(0) == '/' ? resourcePath : "/" + resourcePath);
        if ((path = path.replaceAll("/{2}", "/")).charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            return null;
        }
        return this.classLoader.getResourceAsStream(this.formatResourcePath(resourcePath));
    }

    public boolean canModify(String resourcePath) throws IOException {
        if (StringUtils.isBlank(resourcePath)) {
            return false;
        }
        URL url = this.classLoader.getResource(this.formatResourcePath(resourcePath));
        return url.getProtocol().contains("file");
    }

    @Override
    public boolean exist(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            return false;
        }
        URL url = this.classLoader.getResource(this.formatResourcePath(resourcePath));
        return url != null;
    }

    @Override
    public URL getResource(String resourcePath) throws IOException {
        URL url = this.classLoader.getResource(this.formatResourcePath(resourcePath));
        return url;
    }
}

