/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ReaderInputStream
extends InputStream {
    private Reader reader = null;
    private ByteArrayOutputStream byteArrayOut = null;
    private Writer writer = null;
    private char[] chars = null;
    private byte[] buffer = null;
    private int index;
    private int length = 0;

    public ReaderInputStream(String readerString) {
        this.reader = new StringReader(readerString);
        this.byteArrayOut = new ByteArrayOutputStream();
        this.writer = new OutputStreamWriter(this.byteArrayOut);
        this.chars = new char[1024];
    }

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
        this.byteArrayOut = new ByteArrayOutputStream();
        this.writer = new OutputStreamWriter(this.byteArrayOut);
        this.chars = new char[1024];
    }

    public ReaderInputStream(Reader reader, String encoding) throws UnsupportedEncodingException {
        this.reader = reader;
        this.byteArrayOut = new ByteArrayOutputStream();
        this.writer = new OutputStreamWriter((OutputStream)this.byteArrayOut, encoding);
        this.chars = new char[1024];
    }

    @Override
    public int read() throws IOException {
        if (this.index >= this.length) {
            this.fillBuffer();
        }
        if (this.index >= this.length) {
            return -1;
        }
        return 0xFF & this.buffer[this.index++];
    }

    private void fillBuffer() throws IOException {
        if (this.length < 0) {
            return;
        }
        int numChars = this.reader.read(this.chars);
        if (numChars < 0) {
            this.length = -1;
        } else {
            this.byteArrayOut.reset();
            this.writer.write(this.chars, 0, numChars);
            this.writer.flush();
            this.buffer = this.byteArrayOut.toByteArray();
            this.length = this.buffer.length;
            this.index = 0;
        }
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        if (this.index >= this.length) {
            this.fillBuffer();
        }
        if (this.index >= this.length) {
            return -1;
        }
        int amount = Math.min(len, this.length - this.index);
        System.arraycopy(this.buffer, this.index, data, off, amount);
        this.index += amount;
        return amount;
    }

    @Override
    public int available() throws IOException {
        return this.index < this.length ? this.length - this.index : (this.length >= 0 && this.reader.ready() ? 1 : 0);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

