/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CommonCodeUtils {

    public static abstract class HexConversion {
        public static String str2HexStr(String str) {
            byte[] bs;
            char[] chars = "0123456789ABCDEF".toCharArray();
            StringBuilder sb = new StringBuilder("");
            for (byte element : bs = str.getBytes()) {
                int bit = (element & 0xF0) >> 4;
                sb.append(chars[bit]);
                bit = element & 0xF;
                sb.append(chars[bit]);
            }
            return sb.toString();
        }

        public static String hexStr2Str(String hexStr) {
            String str = "0123456789ABCDEF";
            char[] hexs = hexStr.toCharArray();
            byte[] bytes = new byte[hexStr.length() / 2];
            for (int i = 0; i < bytes.length; ++i) {
                int n = str.indexOf(hexs[2 * i]) * 16;
                bytes[i] = (byte)((n += str.indexOf(hexs[2 * i + 1])) & 0xFF);
            }
            return new String(bytes);
        }

        public static String byte2HexStr(byte[] b) {
            String hs = "";
            String stmp = "";
            for (byte element : b) {
                stmp = Integer.toHexString(element & 0xFF);
                hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
            }
            return hs.toUpperCase();
        }

        public static byte[] hexStr2Bytes(String src) {
            int m = 0;
            int n = 0;
            int l = src.length() / 2;
            byte[] ret = new byte[l];
            for (int i = 0; i < l; ++i) {
                m = i * 2 + 1;
                n = m + 1;
                ret[i] = HexConversion.uniteBytes(src.substring(i * 2, m), src.substring(m, n));
            }
            return ret;
        }

        public static String stringToUnicode(String strText) throws Exception {
            String strRet = "";
            for (int i = 0; i < strText.length(); ++i) {
                char c;
                char intAsc = c = strText.charAt(i);
                String strHex = Integer.toHexString(intAsc);
                strRet = intAsc > '\u0080' ? strRet + "\\u" + strHex : strRet + "\\u00" + strHex;
            }
            return strRet;
        }

        public static String unicodeToString(String hex) {
            int t = hex.length() / 6;
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < t; ++i) {
                String s = hex.substring(i * 6, (i + 1) * 6);
                String s1 = s.substring(2, 4) + "00";
                String s2 = s.substring(4);
                int n = Integer.valueOf(s1, 16) + Integer.valueOf(s2, 16);
                char[] chars = Character.toChars(n);
                str.append(new String(chars));
            }
            return str.toString();
        }

        private static byte uniteBytes(String src0, String src1) {
            byte b0 = Byte.decode("0x" + src0);
            b0 = (byte)(b0 << 4);
            byte b1 = Byte.decode("0x" + src1);
            byte ret = (byte)(b0 | b1);
            return ret;
        }
    }

    public static abstract class MD5 {
        public static String encodeMD5(byte[] source) throws NoSuchAlgorithmException {
            String s = null;
            char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            s = new String(str);
            return s;
        }

        public static String getMD5(String source) throws NoSuchAlgorithmException {
            return MD5.getMD5(source.getBytes());
        }

        public static String getMD5(byte[] source) throws NoSuchAlgorithmException {
            String s = null;
            char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            s = new String(str);
            return s;
        }
    }

    public static abstract class Base64 {
        protected static final String Base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*-";

        public static String base64Encode(String s) {
            if (s == null || s.length() == 0) {
                return s;
            }
            byte[] b = null;
            try {
                b = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return s;
            }
            return Base64.base64EncodeFoArray(b);
        }

        public static String base64EncodeFoArray(byte[] s) {
            if (s == null) {
                return null;
            }
            if (s.length == 0) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            int len = s.length;
            int i = 0;
            while (i < len) {
                int b3;
                int b2;
                byte tmp = s[i++];
                int b0 = (tmp & 0xFC) >> 2;
                int b1 = (tmp & 3) << 4;
                if (i < len) {
                    tmp = s[i++];
                    b1 |= (tmp & 0xF0) >> 4;
                    b2 = (tmp & 0xF) << 2;
                    if (i < len) {
                        tmp = s[i++];
                        b2 |= (tmp & 0xC0) >> 6;
                        b3 = tmp & 0x3F;
                    } else {
                        b3 = 64;
                    }
                } else {
                    b3 = 64;
                    b2 = 64;
                }
                buf.append(Base64Chars.charAt(b0));
                buf.append(Base64Chars.charAt(b1));
                buf.append(Base64Chars.charAt(b2));
                buf.append(Base64Chars.charAt(b3));
            }
            return buf.toString();
        }

        public static String base64Decode(String s) {
            byte[] b = Base64.base64DecodeToArray(s);
            if (b == null) {
                return null;
            }
            if (b.length == 0) {
                return "";
            }
            try {
                return new String(b, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static byte[] base64DecodeToArray(String s) {
            if (s == null) {
                return null;
            }
            int len = s.length();
            if (len == 0) {
                return new byte[0];
            }
            if (len % 4 != 0) {
                throw new IllegalArgumentException(s);
            }
            byte[] b = new byte[len / 4 * 3];
            int i = 0;
            int j = 0;
            int e = 0;
            while (i < len) {
                int c = Base64Chars.indexOf(s.charAt(i++));
                int tmp = c << 18;
                c = Base64Chars.indexOf(s.charAt(i++));
                tmp |= c << 12;
                if ((c = Base64Chars.indexOf(s.charAt(i++))) < 64) {
                    tmp |= c << 6;
                    if ((c = Base64Chars.indexOf(s.charAt(i++))) < 64) {
                        tmp |= c;
                    } else {
                        e = 1;
                    }
                } else {
                    e = 2;
                    ++i;
                }
                b[j + 2] = (byte)(tmp & 0xFF);
                b[j + 1] = (byte)((tmp >>= 8) & 0xFF);
                b[j + 0] = (byte)((tmp >>= 8) & 0xFF);
                j += 3;
            }
            if (e != 0) {
                len = b.length - e;
                byte[] copy = new byte[len];
                System.arraycopy(b, 0, copy, 0, len);
                return copy;
            }
            return b;
        }
    }
}

