/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.hasor.utils.StringUtils;

public class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    private static final Map<String, String> abbreviationMap = new HashMap<String, String>();
    private static final Map<String, String> reverseAbbreviationMap = new HashMap<String, String>();

    private static void addAbbreviation(String primitive, String abbreviation) {
        abbreviationMap.put(primitive, abbreviation);
        reverseAbbreviationMap.put(abbreviation, primitive);
    }

    public static String getShortClassName(String className) {
        int lastDotIdx;
        if (className == null) {
            return "";
        }
        if (className.length() == 0) {
            return "";
        }
        StringBuilder arrayPrefix = new StringBuilder();
        if (className.startsWith("[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append("[]");
            }
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                className = className.substring(1, className.length() - 1);
            }
        }
        if (reverseAbbreviationMap.containsKey(className)) {
            className = reverseAbbreviationMap.get(className);
        }
        int innerIdx = className.indexOf(36, (lastDotIdx = className.lastIndexOf(46)) == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring(lastDotIdx + 1);
        if (innerIdx != -1) {
            out = out.replace('$', '.');
        }
        return out + arrayPrefix;
    }

    public static String getShortCanonicalName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortCanonicalName(cls.getName());
    }

    public static String getShortCanonicalName(String canonicalName) {
        return ClassUtils.getShortClassName(ClassUtils.getCanonicalName(canonicalName));
    }

    public static Class<?> getClass(ClassLoader classLoader, String className, boolean initialize) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            if (abbreviationMap.containsKey(className)) {
                String clsName = "[" + abbreviationMap.get(className);
                clazz = Class.forName(clsName, initialize, classLoader).getComponentType();
            } else {
                clazz = Class.forName(ClassUtils.toCanonicalName(className), initialize, classLoader);
            }
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    return ClassUtils.getClass(classLoader, className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1), initialize);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static Class<?> getClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return ClassUtils.getClass(classLoader, className, true);
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClass(className, true);
    }

    public static Class<?> getClass(String className, boolean initialize) throws ClassNotFoundException {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = contextCL == null ? ClassUtils.class.getClassLoader() : contextCL;
        return ClassUtils.getClass(loader, className, initialize);
    }

    public static ClassLoader getClassLoader(ClassLoader classLoader) {
        classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }

    private static String getCanonicalName(String className) {
        if (!StringUtils.isEmpty(className)) {
            int sz = className.length();
            char[] chs = new char[sz];
            int count = 0;
            for (int i = 0; i < sz; ++i) {
                if (Character.isWhitespace(className.charAt(i))) continue;
                chs[count++] = className.charAt(i);
            }
            if (count != sz) {
                className = new String(chs, 0, count);
            }
        }
        if (className == null) {
            return null;
        }
        int dim = 0;
        while (className.startsWith("[")) {
            ++dim;
            className = className.substring(1);
        }
        if (dim < 1) {
            return className;
        }
        if (className.startsWith("L")) {
            className = className.substring(1, className.endsWith(";") ? className.length() - 1 : className.length());
        } else if (className.length() > 0) {
            className = reverseAbbreviationMap.get(className.substring(0, 1));
        }
        StringBuilder canonicalClassNameBuffer = new StringBuilder(className);
        for (int i = 0; i < dim; ++i) {
            canonicalClassNameBuffer.append("[]");
        }
        return canonicalClassNameBuffer.toString();
    }

    private static String toCanonicalName(String className) {
        if ((className = StringUtils.deleteWhitespace(className)) == null) {
            throw new NullPointerException("className must not be null.");
        }
        if (className.endsWith("[]")) {
            StringBuilder classNameBuffer = new StringBuilder();
            while (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = abbreviationMap.get(className);
            if (abbreviation != null) {
                classNameBuffer.append(abbreviation);
            } else {
                classNameBuffer.append("L").append(className).append(";");
            }
            className = classNameBuffer.toString();
        }
        return className;
    }

    public static String getDescName(Class<?> type) {
        if (type == Void.class) {
            return "void ";
        }
        if (type.isPrimitive()) {
            return ClassUtils.getShortCanonicalName(type);
        }
        if (type.isArray()) {
            return type.getComponentType().getName() + "[]";
        }
        return type.getName();
    }

    public static String getDescNameWithOutModifiers(Method method) {
        StringBuffer str = new StringBuffer("");
        Class<?> returnType = method.getReturnType();
        str.append(ClassUtils.getDescName(returnType) + " ");
        Class<?> decType = method.getDeclaringClass();
        str.append(decType.getName());
        str.append(".");
        str.append(method.getName());
        Class<?>[] paramTypes = method.getParameterTypes();
        str.append("(");
        if (paramTypes != null) {
            for (int j = 0; j < paramTypes.length; ++j) {
                str.append(ClassUtils.getDescName(paramTypes[j]));
                if (j >= paramTypes.length - 1) continue;
                str.append(",");
            }
        }
        str.append(")");
        return str.toString();
    }

    public static Class<?>[] getAllInterfaces(Class<?> faceType) {
        HashSet classes = new HashSet();
        ClassUtils.intoInterfaces(faceType, classes);
        return classes.toArray(new Class[classes.size()]);
    }

    private static void intoInterfaces(Class<?> faceType, Set<Class<?>> intoSet) {
        Class<?>[] interfaces;
        if (faceType.isInterface()) {
            intoSet.add(faceType);
        }
        for (Class<?> faces : interfaces = faceType.getInterfaces()) {
            ClassUtils.intoInterfaces(faces, intoSet);
        }
    }

    static {
        ClassUtils.addAbbreviation("int", "I");
        ClassUtils.addAbbreviation("boolean", "Z");
        ClassUtils.addAbbreviation("float", "F");
        ClassUtils.addAbbreviation("long", "J");
        ClassUtils.addAbbreviation("short", "S");
        ClassUtils.addAbbreviation("byte", "B");
        ClassUtils.addAbbreviation("double", "D");
        ClassUtils.addAbbreviation("char", "C");
    }
}

