/*
 * Decompiled with CFR 0.152.
 */
package name.finsterwalder.fileutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import name.finsterwalder.fileutils.FileChangeListener;
import name.finsterwalder.fileutils.FileWatcher;
import name.finsterwalder.utils.Ensure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingFileWatcher
implements FileWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingFileWatcher.class);
    public static final int DEFAULT_RELOAD_INTERVAL_IN_MS = 500;
    public static final int DEFAULT_GRACE_PERIOD_IN_MS = 1000;
    private final ScheduledExecutorService executorService;
    private final Path path;
    private final FileChangeListener fileChangeListener;
    private final long gracePeriodInMs;
    private volatile FileTime lastSeen;
    private volatile boolean changed = false;
    private final Thread shutdownHook = new Thread(){

        @Override
        public void run() {
            PollingFileWatcher.this.executorService.shutdownNow();
        }
    };

    public PollingFileWatcher(String filenameOfFileToWatch, FileChangeListener fileChangeListener) {
        this(Paths.get(filenameOfFileToWatch, new String[0]), fileChangeListener, 500L, 1000L, Executors.newSingleThreadScheduledExecutor());
    }

    public PollingFileWatcher(File fileToWatch, FileChangeListener fileChangeListener) {
        this(fileToWatch.toPath(), fileChangeListener, 500L, 1000L, Executors.newSingleThreadScheduledExecutor());
    }

    public PollingFileWatcher(Path fileToWatch, FileChangeListener fileChangeListener) {
        this(fileToWatch, fileChangeListener, 500L, 1000L, Executors.newSingleThreadScheduledExecutor());
    }

    public PollingFileWatcher(String filenameOfFileToWatch, FileChangeListener fileChangeListener, long reloadIntervalInMs) {
        this(Paths.get(filenameOfFileToWatch, new String[0]), fileChangeListener, reloadIntervalInMs, 1000L, Executors.newSingleThreadScheduledExecutor());
    }

    public PollingFileWatcher(File fileToWatch, FileChangeListener fileChangeListener, long reloadIntervalInMs) {
        this(fileToWatch.toPath(), fileChangeListener, reloadIntervalInMs, 1000L, Executors.newSingleThreadScheduledExecutor());
    }

    public PollingFileWatcher(Path fileToWatch, FileChangeListener fileChangeListener, long reloadIntervalInMs) {
        this(fileToWatch, fileChangeListener, reloadIntervalInMs, 1000L, Executors.newSingleThreadScheduledExecutor());
    }

    public PollingFileWatcher(String filename, FileChangeListener fileChangeListener, long reloadIntervalInMs, long gracePeriodInMs) {
        this(Paths.get(filename, new String[0]), fileChangeListener, reloadIntervalInMs, gracePeriodInMs, Executors.newSingleThreadScheduledExecutor());
    }

    public PollingFileWatcher(File fileToWatch, FileChangeListener fileChangeListener, long reloadIntervalInMs, long gracePeriodInMs) {
        this(fileToWatch.toPath(), fileChangeListener, reloadIntervalInMs, gracePeriodInMs, Executors.newSingleThreadScheduledExecutor());
    }

    public PollingFileWatcher(Path fileToWatch, FileChangeListener fileChangeListener, long reloadIntervalInMs, long gracePeriodInMs) {
        this(fileToWatch, fileChangeListener, reloadIntervalInMs, gracePeriodInMs, Executors.newSingleThreadScheduledExecutor());
    }

    PollingFileWatcher(Path path, FileChangeListener fileChangeListener, long reloadIntervalInMs, long gracePeriodInMs, ScheduledExecutorService executorService) {
        Ensure.notNull(path, "path");
        Ensure.notNull(fileChangeListener, "fileChangeListener");
        Ensure.notNull(executorService, "executorService");
        Ensure.that(reloadIntervalInMs > 0L, "reload interval > 0");
        Ensure.that(gracePeriodInMs >= 0L, "grace period >= 0");
        this.executorService = executorService;
        this.path = path;
        this.gracePeriodInMs = gracePeriodInMs;
        this.fileChangeListener = fileChangeListener;
        this.changed();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.executorService.scheduleAtFixedRate(new ChangeWatcher(this), reloadIntervalInMs, reloadIntervalInMs, TimeUnit.MILLISECONDS);
    }

    private synchronized boolean changed() {
        try {
            FileTime lastModified = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            if (this.lastSeen == null || lastModified.compareTo(this.lastSeen) > 0) {
                this.lastSeen = lastModified;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return this.lastSeen != null;
        }
    }

    @Override
    public void unwatch() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.executorService.shutdownNow();
    }

    protected void finalize() throws Throwable {
        this.unwatch();
        super.finalize();
    }

    static class DelayedNotifier
    implements Runnable {
        private final PollingFileWatcher watcher;

        public DelayedNotifier(PollingFileWatcher watcher) {
            this.watcher = watcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PollingFileWatcher pollingFileWatcher = this.watcher;
                synchronized (pollingFileWatcher) {
                    if (this.watcher.changed()) {
                        this.watcher.executorService.schedule(this, this.watcher.gracePeriodInMs, TimeUnit.MILLISECONDS);
                    } else {
                        this.watcher.changed = false;
                        this.watcher.fileChangeListener.fileChanged();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("PollingFileWatcher could not check file {}.", (Object)this.watcher.path, (Object)e);
            }
        }
    }

    static class ChangeWatcher
    implements Runnable {
        private final PollingFileWatcher watcher;

        public ChangeWatcher(PollingFileWatcher watcher) {
            this.watcher = watcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PollingFileWatcher pollingFileWatcher = this.watcher;
                synchronized (pollingFileWatcher) {
                    if (!this.watcher.changed && (this.watcher.changed = this.watcher.changed())) {
                        if (this.watcher.gracePeriodInMs > 0L) {
                            this.watcher.executorService.schedule(new DelayedNotifier(this.watcher), this.watcher.gracePeriodInMs, TimeUnit.MILLISECONDS);
                        } else {
                            this.watcher.fileChangeListener.fileChanged();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("PollingFileWatcher could not check file {}.", (Object)this.watcher.path, (Object)e);
            }
        }
    }
}

