/*
 * Decompiled with CFR 0.152.
 */
package name.finsterwalder.fileutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import name.finsterwalder.fileutils.FileChangeListener;
import name.finsterwalder.fileutils.FileWatcher;
import name.finsterwalder.fileutils.PollingFileWatcher;
import name.finsterwalder.utils.Ensure;
import name.finsterwalder.utils.SimpleDateTimeProvider;
import name.finsterwalder.utils.TimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioFileWatcher
implements FileWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioFileWatcher.class);
    private static final int DEFAULT_GRACE_PERIOD = 1000;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private PollingFileWatcher pollingFileWatcher;
    private WatchService watchService;
    private final Path absoluteFileToWatch;
    private volatile long lastChanged;
    private volatile long lastProcessed;
    private final TimeProvider timeProvider;

    public NioFileWatcher(String filenameOfFileToWatch, FileChangeListener fileChangeListener) {
        this(Paths.get(filenameOfFileToWatch, new String[0]), fileChangeListener, 1000L, new SimpleDateTimeProvider());
    }

    public NioFileWatcher(File fileToWatch, FileChangeListener fileChangeListener) {
        this(fileToWatch.toPath(), fileChangeListener, 1000L, new SimpleDateTimeProvider());
    }

    public NioFileWatcher(Path fileToWatch, FileChangeListener fileChangeListener) {
        this(fileToWatch, fileChangeListener, 1000L, new SimpleDateTimeProvider());
    }

    public NioFileWatcher(String filenameOfFileToWatch, FileChangeListener fileChangeListener, long gracePeriodInMs) {
        this(FileSystems.getDefault().getPath(filenameOfFileToWatch, new String[0]), fileChangeListener, gracePeriodInMs, new SimpleDateTimeProvider());
    }

    public NioFileWatcher(File fileToWatch, FileChangeListener fileChangeListener, long gracePeriodInMs) {
        this(fileToWatch.toPath(), fileChangeListener, gracePeriodInMs, new SimpleDateTimeProvider());
    }

    public NioFileWatcher(Path fileToWatch, FileChangeListener fileChangeListener, long gracePeriodInMs) {
        this(fileToWatch, fileChangeListener, gracePeriodInMs, new SimpleDateTimeProvider());
    }

    NioFileWatcher(Path fileToWatch, final FileChangeListener fileChangeListener, final long gracePeriodInMs, TimeProvider timeProvider) {
        Ensure.notNull(fileToWatch, "fileToWatch");
        Ensure.notNull(fileChangeListener, "fileChangeListener");
        Ensure.notNull(timeProvider, "timeProvider");
        this.timeProvider = timeProvider;
        this.absoluteFileToWatch = fileToWatch.toAbsolutePath();
        final Path directoryPath = this.absoluteFileToWatch.getParent();
        if (directoryPath == null) {
            throw new IllegalArgumentException("File does not have a parent directory: " + this.absoluteFileToWatch);
        }
        if (Files.exists(directoryPath, new LinkOption[0])) {
            this.initWatcher(directoryPath, fileChangeListener, gracePeriodInMs);
        } else {
            this.pollingFileWatcher = new PollingFileWatcher(this.absoluteFileToWatch, new FileChangeListener(){

                @Override
                public void fileChanged() {
                    NioFileWatcher.this.pollingFileWatcher.unwatch();
                    NioFileWatcher.this.pollingFileWatcher = null;
                    NioFileWatcher.this.initWatcher(directoryPath, fileChangeListener, gracePeriodInMs);
                    fileChangeListener.fileChanged();
                }
            }, 500L, gracePeriodInMs);
        }
    }

    protected void finalize() throws Throwable {
        this.unwatch();
        super.finalize();
    }

    private void initWatcher(Path directoryPath, final FileChangeListener fileChangeListener, final long gracePeriod) {
        final Path filenamePath = this.absoluteFileToWatch.getFileName();
        try {
            this.watchService = directoryPath.getFileSystem().newWatchService();
            directoryPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean valid = true;
                    try {
                        while (valid && !this.isInterrupted()) {
                            WatchKey takenWatchKey = NioFileWatcher.this.watchService.take();
                            for (WatchEvent<?> event : takenWatchKey.pollEvents()) {
                                Path context;
                                if (StandardWatchEventKinds.OVERFLOW == event.kind() || !filenamePath.equals(context = (Path)event.context())) continue;
                                this.notifyChangeListener(fileChangeListener, gracePeriod);
                            }
                            valid = takenWatchKey.reset();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ClosedWatchServiceException closedWatchServiceException) {
                    }
                    finally {
                        NioFileWatcher.close(NioFileWatcher.this.watchService, NioFileWatcher.this.absoluteFileToWatch);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void notifyChangeListener(final FileChangeListener fileChangeListener2, long gracePeriod2) {
                    if (gracePeriod2 > 0L) {
                        final long changeTimestamp = NioFileWatcher.this.timeProvider.getTime();
                        NioFileWatcher nioFileWatcher = NioFileWatcher.this;
                        synchronized (nioFileWatcher) {
                            NioFileWatcher.this.lastChanged = changeTimestamp;
                        }
                        NioFileWatcher.this.scheduler.schedule(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                NioFileWatcher nioFileWatcher = NioFileWatcher.this;
                                synchronized (nioFileWatcher) {
                                    if (changeTimestamp == NioFileWatcher.this.lastChanged && NioFileWatcher.this.lastProcessed < NioFileWatcher.this.lastChanged) {
                                        NioFileWatcher.this.lastProcessed = NioFileWatcher.this.lastChanged;
                                        fileChangeListener2.fileChanged();
                                    }
                                }
                            }
                        }, gracePeriod2, TimeUnit.MILLISECONDS);
                    } else {
                        fileChangeListener2.fileChanged();
                    }
                }
            }.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize file watcher for " + this.absoluteFileToWatch.toAbsolutePath(), e);
        }
    }

    @Override
    public void unwatch() {
        NioFileWatcher.close(this.watchService, this.absoluteFileToWatch);
        if (this.pollingFileWatcher != null) {
            this.pollingFileWatcher.unwatch();
            this.pollingFileWatcher = null;
        }
    }

    private static void close(WatchService watchService, Path fileToWatch) {
        if (watchService != null) {
            try {
                watchService.close();
            }
            catch (IOException e) {
                LOGGER.info("Could not close file watcher for {}", (Object)fileToWatch.toAbsolutePath(), (Object)e);
            }
        }
    }
}

