/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.io.IOException;
import mockit.external.asm.ClassReader;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.commons.EmptyVisitor;
import mockit.internal.ClassFile;

public final class SuperConstructorCollector
extends EmptyVisitor {
    private final int desiredConstructorNo;
    private int constructorNo;
    private String targetConstructorDesc;

    public SuperConstructorCollector(int desiredConstructorNo) {
        this.desiredConstructorNo = desiredConstructorNo;
    }

    public String findConstructor(String superClassName) {
        ClassReader cr;
        this.constructorNo = 0;
        this.targetConstructorDesc = null;
        try {
            cr = ClassFile.readClass(superClassName);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for " + superClassName, e);
        }
        cr.accept(this, true);
        if (this.targetConstructorDesc == null) {
            throw new IllegalArgumentException("Constructor number " + this.desiredConstructorNo + " not found in " + superClassName);
        }
        return this.targetConstructorDesc;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            ++this.constructorNo;
            if (this.constructorNo == this.desiredConstructorNo) {
                this.targetConstructorDesc = desc;
            }
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }
}

