/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import mockit.external.asm.ClassReader;
import mockit.integration.junit3.internal.JUnitTestCaseDecorator;
import mockit.integration.junit3.internal.TestSuiteDecorator;
import mockit.integration.junit4.internal.BlockJUnit4ClassRunnerDecorator;
import mockit.integration.junit4.internal.RunNotifierDecorator;
import mockit.integration.testng.internal.TestNGTestRunnerDecorator;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.transformation.ExpectationsTransformer;
import mockit.internal.startup.AgentInitialization;
import mockit.internal.startup.ProxyRegistrationTransformer;
import mockit.internal.startup.ToolLoader;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Startup {
    static final String javaSpecVersion = System.getProperty("java.specification.version");
    static final boolean jdk6OrLater = "1.6".equals(javaSpecVersion) || "1.7".equals(javaSpecVersion);
    private static Instrumentation instrumentation;
    private static final Properties startupTools;
    private static final List<String> defaultTools;

    private Startup() {
    }

    public static boolean isJava6OrLater() {
        return jdk6OrLater;
    }

    public static void premain(String agentArgs, Instrumentation inst) throws Exception {
        Startup.initialize(agentArgs, inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) throws Exception {
        Startup.initialize(agentArgs, inst);
    }

    private static void initialize(String agentArgs, Instrumentation inst) throws IOException, ClassNotFoundException {
        instrumentation = inst;
        Class.forName("mockit.internal.MockingBridge");
        Startup.loadInternalStartupMocks();
        if (agentArgs != null && agentArgs.length() > 0) {
            Startup.processAgentArgs(agentArgs);
        }
        for (String toolSpec : defaultTools) {
            Startup.loadExternalTool(toolSpec, true);
        }
        instrumentation.addTransformer(new ProxyRegistrationTransformer());
        instrumentation.addTransformer(new ExpectationsTransformer(inst));
    }

    private static void loadInternalStartupMocks() {
        Startup.setUpInternalStartupMock(TestSuiteDecorator.class);
        Startup.setUpInternalStartupMock(JUnitTestCaseDecorator.class);
        Startup.setUpInternalStartupMock(RunNotifierDecorator.class);
        Startup.setUpInternalStartupMock(BlockJUnit4ClassRunnerDecorator.class);
        Startup.setUpInternalStartupMock(TestNGTestRunnerDecorator.class);
        TestRun.mockFixture().turnRedefinedClassesIntoFixedOnes();
    }

    private static void setUpInternalStartupMock(Class<?> mockClass) {
        Object mock;
        try {
            mock = mockClass.newInstance();
        }
        catch (Throwable ignored) {
            return;
        }
        new RedefinitionEngine(mock, mockClass, true).setUpStartupMock();
    }

    private static void processAgentArgs(String agentArgs) throws IOException {
        String[] externalToolSpecs;
        for (String toolSpec : externalToolSpecs = agentArgs.split("\\s*;\\s*")) {
            Startup.loadExternalTool(toolSpec, false);
        }
    }

    private static void loadExternalTool(String toolSpec, boolean byDefault) throws IOException {
        ClassReader cr;
        String toolKey;
        String toolArgs;
        String[] classAndArgs = toolSpec.split("\\s*=\\s*");
        String toolClassName = classAndArgs[0];
        String string = toolArgs = classAndArgs.length == 1 ? null : classAndArgs[1];
        if (!byDefault) {
            defaultTools.remove(toolClassName);
        }
        if (startupTools.containsKey(toolKey = "startupTools." + toolClassName)) {
            toolClassName = startupTools.getProperty(toolKey);
        }
        if (byDefault) {
            try {
                cr = ClassFile.readClass(toolClassName);
            }
            catch (IOException ignore) {
                return;
            }
        } else {
            cr = ClassFile.readClass(toolClassName);
        }
        Startup.loadExternalTool(toolClassName, toolArgs, cr);
    }

    private static void loadExternalTool(String toolClassName, String toolArgs, ClassReader cr) {
        ToolLoader toolLoader = new ToolLoader(toolClassName, toolArgs);
        try {
            cr.accept(toolLoader, true);
        }
        catch (IllegalStateException ignore) {
            return;
        }
        String toolArgsDescription = toolArgs == null ? "" : '=' + toolArgs;
        System.out.println("JMockit: loaded external tool " + toolClassName + toolArgsDescription);
    }

    public static Instrumentation instrumentation() {
        Startup.verifyInitialization();
        return instrumentation;
    }

    public static void verifyInitialization() {
        if (instrumentation == null) {
            new AgentInitialization().initializeAccordingToJDKVersion();
            System.out.println("WARNING: JMockit was initialized on demand, which may cause certain tests to fail;\nplease check the documentation for better ways to get it initialized.");
        }
    }

    public static void initializeIfNeeded() {
        if (instrumentation == null) {
            try {
                new AgentInitialization().initializeAccordingToJDKVersion();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    static {
        startupTools = new Properties();
        defaultTools = new ArrayList<String>();
        InputStream properties = Startup.class.getResourceAsStream("/jmockit.properties");
        try {
            startupTools.load(properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                properties.close();
            }
            catch (IOException iOException) {}
        }
        String specifiedTools = System.getProperty("jmockit-tools");
        String[] defaultToolsArray = specifiedTools != null ? specifiedTools.split(",") : startupTools.getProperty("defaultTools", "").split("\\s+");
        Collections.addAll(defaultTools, defaultToolsArray);
    }
}

