/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProxyRegistrationTransformer
implements ClassFileTransformer {
    ProxyRegistrationTransformer() {
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (classBeingRedefined == null) {
            this.registerClassIfProxy(className, classfileBuffer);
            this.enableAssertsIfTestClass(loader, protectionDomain, className);
        }
        return null;
    }

    private void registerClassIfProxy(String className, byte[] classfileBuffer) {
        int p = className.indexOf("$Proxy");
        if (p >= 0 && Utilities.isPositiveDigit(className.charAt(p + 6))) {
            if (p == 0) {
                TestRun.proxyClasses().add(className, classfileBuffer);
            } else if (className.charAt(p - 1) == '/') {
                TestRun.proxyClasses().add(className.replace('/', '.'), classfileBuffer);
            }
        }
    }

    private void enableAssertsIfTestClass(ClassLoader loader, ProtectionDomain protectionDomain, String className) {
        if (loader != null && protectionDomain != null && (className.endsWith("Test") || this.isFromTestClassesDirectory(protectionDomain))) {
            loader.setClassAssertionStatus(className.replace('/', '.'), true);
        }
    }

    private boolean isFromTestClassesDirectory(ProtectionDomain protectionDomain) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        URL location = codeSource.getLocation();
        return location != null && location.getPath().endsWith("/test-classes/");
    }
}

