/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.filtering;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mockit.external.asm.Type;
import mockit.internal.filtering.MockFilter;
import mockit.internal.util.SuperConstructorCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockingConfiguration {
    private final List<MockFilter> filtersToApply;
    private final boolean desiredFilterResultWhenMatching;
    private String superClassName;
    private MockFilter lastFilterMatched;

    public MockingConfiguration(List<MockFilter> filters, boolean desiredFilterResultWhenMatching) {
        this.filtersToApply = filters;
        this.desiredFilterResultWhenMatching = desiredFilterResultWhenMatching;
    }

    public MockingConfiguration(String[] filters, boolean desiredFilterResultWhenMatching) {
        this.filtersToApply = this.parseMockFilters(filters);
        this.desiredFilterResultWhenMatching = desiredFilterResultWhenMatching;
    }

    private List<MockFilter> parseMockFilters(String[] mockFilters) {
        if (mockFilters == null || mockFilters.length == 0) {
            return null;
        }
        ArrayList<MockFilter> filters = new ArrayList<MockFilter>(mockFilters.length);
        for (String mockFilter : mockFilters) {
            filters.add(new RegexMockFilter(mockFilter));
        }
        return filters;
    }

    public boolean isEmpty() {
        return this.filtersToApply == null;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public boolean matchesFilters(String name, String desc) {
        if (this.filtersToApply == null) {
            return true;
        }
        for (MockFilter filter : this.filtersToApply) {
            if (!filter.matches(name, desc)) continue;
            this.lastFilterMatched = filter;
            return this.desiredFilterResultWhenMatching;
        }
        this.lastFilterMatched = null;
        return !this.desiredFilterResultWhenMatching;
    }

    public Type[] getSuperConstructorParameterTypes() {
        int superConstructorNo;
        RegexMockFilter regexFilterMatched;
        if (this.lastFilterMatched instanceof RegexMockFilter) {
            regexFilterMatched = (RegexMockFilter)this.lastFilterMatched;
            superConstructorNo = regexFilterMatched.superConstructorNo;
        } else {
            regexFilterMatched = null;
            superConstructorNo = 1;
        }
        if (superConstructorNo > 0) {
            String constructorDesc = new SuperConstructorCollector(superConstructorNo).findConstructor(this.superClassName);
            return Type.getArgumentTypes(constructorDesc);
        }
        if (regexFilterMatched.paramsForSuperConstructor == null) {
            return null;
        }
        String[] params = regexFilterMatched.paramsForSuperConstructor;
        Type[] types = new Type[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = this.getParameterType(params[i]);
        }
        return types;
    }

    private Type getParameterType(String param) {
        if ("boolean".equals(param)) {
            return Type.BOOLEAN_TYPE;
        }
        if ("char".equals(param)) {
            return Type.CHAR_TYPE;
        }
        if ("byte".equals(param)) {
            return Type.BYTE_TYPE;
        }
        if ("short".equals(param)) {
            return Type.SHORT_TYPE;
        }
        if ("int".equals(param)) {
            return Type.INT_TYPE;
        }
        if ("long".equals(param)) {
            return Type.LONG_TYPE;
        }
        if ("float".equals(param)) {
            return Type.FLOAT_TYPE;
        }
        if ("double".equals(param)) {
            return Type.DOUBLE_TYPE;
        }
        if (param.endsWith("[]")) {
            return null;
        }
        return this.getReferenceParameterType(param);
    }

    private Type getReferenceParameterType(String param) {
        String fqParameterName = param.indexOf(46) < 0 ? "java.lang." + param : param;
        String parameterDesc = 'L' + fqParameterName.replace('.', '/') + ';';
        return Type.getType(parameterDesc);
    }

    private static final class RegexMockFilter
    implements MockFilter {
        private static final Pattern CONSTRUCTOR_NAME_REGEX = Pattern.compile("<init>");
        private static final String[] ANY_PARAMS = new String[0];
        private final Pattern nameRegex;
        private final String[] paramTypeNames;
        private String[] paramsForSuperConstructor;
        private int superConstructorNo;

        private RegexMockFilter(String filter) {
            int lp = filter.indexOf(40);
            int rp = filter.indexOf(41);
            if (lp < 0 && rp >= 0 || lp >= 0 && lp >= rp) {
                throw new IllegalArgumentException("Invalid filter: " + filter);
            }
            if (lp == 0) {
                this.nameRegex = CONSTRUCTOR_NAME_REGEX;
                this.parseSuperConstructorSpecification(filter);
            } else {
                this.nameRegex = Pattern.compile(lp < 0 ? filter : filter.substring(0, lp));
            }
            this.paramTypeNames = this.parseParameterTypes(filter, lp, rp);
        }

        private void parseSuperConstructorSpecification(String filter) {
            int cp = filter.indexOf(58);
            if (cp < 0) {
                this.superConstructorNo = 1;
                return;
            }
            String specification = filter.substring(cp + 1).trim();
            int rp = specification.length() - 1;
            if (specification.charAt(0) == '(' && specification.charAt(rp) == ')') {
                this.paramsForSuperConstructor = this.parseParameterTypes(specification, 0, rp);
            } else {
                try {
                    this.superConstructorNo = Integer.parseInt(specification);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid specification for super constructor in filter: " + filter, e);
                }
            }
        }

        private String[] parseParameterTypes(String filter, int lp, int rp) {
            if (lp < 0) {
                return ANY_PARAMS;
            }
            if (lp == rp - 1) {
                return null;
            }
            String[] paramTypeNames = filter.substring(lp + 1, rp).split(",");
            for (int i = 0; i < paramTypeNames.length; ++i) {
                paramTypeNames[i] = paramTypeNames[i].trim();
            }
            return paramTypeNames;
        }

        public boolean matches(String name, String desc) {
            if (!this.nameRegex.matcher(name).matches()) {
                return false;
            }
            if (this.paramTypeNames == ANY_PARAMS) {
                return true;
            }
            if (this.paramTypeNames == null) {
                return desc.charAt(1) == ')';
            }
            Type[] argTypes = Type.getArgumentTypes(desc);
            if (argTypes.length != this.paramTypeNames.length) {
                return false;
            }
            for (int i = 0; i < this.paramTypeNames.length; ++i) {
                Type argType = argTypes[i];
                String paramTypeName = argType.getClassName();
                if (paramTypeName.endsWith(this.paramTypeNames[i])) continue;
                return false;
            }
            return true;
        }
    }
}

