/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Modifier;
import mockit.external.asm.ClassReader;
import mockit.internal.expectations.mocking.BaseTypeRedefinition;
import mockit.internal.expectations.mocking.ExpectationsModifier;
import mockit.internal.expectations.mocking.MockConstructorInfo;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeRedefinition
extends BaseTypeRedefinition {
    private final Object objectWithInitializerMethods;

    TypeRedefinition(Object objectWithInitializerMethods, MockedType typeMetadata) {
        super(typeMetadata.getClassType());
        this.objectWithInitializerMethods = objectWithInitializerMethods;
        this.typeMetadata = typeMetadata;
    }

    void redefineTypeForFinalField() {
        this.buildMockingConfigurationFromSpecifiedMetadata();
        this.adjustTargetClassIfRealClassNameSpecified();
        if (this.targetClass == null || this.targetClass.isInterface()) {
            throw new IllegalArgumentException("Final mock field must be of a class type, or otherwise the real class must be specified through the @Mocked annotation:\n" + this.typeMetadata.mockId);
        }
        Integer mockedClassId = this.redefineClassesFromCache();
        if (mockedClassId != null) {
            this.redefineMethodsAndConstructorsInTargetType();
            this.storeRedefinedClassesInCache(mockedClassId);
        }
    }

    Object redefineType() {
        this.buildMockingConfigurationFromSpecifiedMetadata();
        this.adjustTargetClassIfRealClassNameSpecified();
        return this.redefineType(this.typeMetadata.declaredType);
    }

    private void buildMockingConfigurationFromSpecifiedMetadata() {
        boolean filterResultWhenMatching = !this.typeMetadata.hasInverseFilters();
        this.mockingCfg = new MockingConfiguration(this.typeMetadata.getFilters(), filterResultWhenMatching);
        this.mockConstructorInfo = new MockConstructorInfo(this.objectWithInitializerMethods, this.typeMetadata);
    }

    private void adjustTargetClassIfRealClassNameSpecified() {
        String realClassName = this.typeMetadata.getRealClassName();
        if (realClassName.length() > 0) {
            this.targetClass = Utilities.loadClass(realClassName);
        }
    }

    @Override
    ExpectationsModifier createModifier(Class<?> realClass, ClassReader classReader) {
        MockConstructorInfo constructorInfoToUse = Modifier.isAbstract(this.targetClass.getModifiers()) ? null : this.mockConstructorInfo;
        return new ExpectationsModifier(realClass.getClassLoader(), classReader, this.mockingCfg, constructorInfoToUse);
    }

    @Override
    String getNameForConcreteSubclassToCreate() {
        Package testPackage = this.objectWithInitializerMethods.getClass().getPackage();
        String prefix = testPackage == null ? "" : testPackage.getName() + '.';
        return prefix + "$Subclass_" + this.typeMetadata.mockId;
    }
}

