/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import mockit.internal.expectations.mocking.CaptureOfNewInstancesForParameters;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TypeRedefinition;
import mockit.internal.expectations.mocking.TypeRedefinitions;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterTypeRedefinitions
extends TypeRedefinitions {
    private final Type[] paramTypes;
    private final Annotation[][] paramAnnotations;
    private final Object[] paramValues;
    private final List<Object> nonStrictMocks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterTypeRedefinitions(Object objectWithInitializerMethods, Method testMethod) {
        super(objectWithInitializerMethods);
        this.paramTypes = testMethod.getGenericParameterTypes();
        this.paramAnnotations = testMethod.getParameterAnnotations();
        this.paramValues = new Object[this.paramTypes.length];
        this.nonStrictMocks = new ArrayList<Object>();
        TestRun.enterNoMockingZone();
        try {
            for (int i = 0; i < this.paramTypes.length; ++i) {
                this.redefineTypeForMockParameter(i);
            }
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private void redefineTypeForMockParameter(int paramIndex) {
        Object mock;
        Type paramType = this.paramTypes[paramIndex];
        MockedType typeMetadata = new MockedType(paramIndex, paramType, this.paramAnnotations[paramIndex]);
        if (!typeMetadata.isMockParameter()) {
            return;
        }
        TypeRedefinition typeRedefinition = new TypeRedefinition(this.parentObject, typeMetadata);
        this.paramValues[paramIndex] = mock = typeRedefinition.redefineType();
        typeMetadata.mockingCfg = typeRedefinition.mockingCfg;
        if (typeMetadata.nonStrict) {
            this.nonStrictMocks.add(mock);
        }
        if (typeMetadata.getMaxInstancesToCapture() > 0) {
            this.registerCaptureOfNewInstances(typeMetadata);
        }
        this.targetClasses.add(typeRedefinition.targetClass);
        ++this.typesRedefined;
    }

    private void registerCaptureOfNewInstances(MockedType typeMetadata) {
        CaptureOfNewInstancesForParameters capture = this.getCaptureOfNewInstances();
        if (capture == null) {
            capture = new CaptureOfNewInstancesForParameters();
            this.captureOfNewInstances = capture;
        }
        capture.registerCaptureOfNewInstances(typeMetadata);
        Class<?> paramClass = typeMetadata.getClassType();
        capture.makeSureAllSubtypesAreModified(paramClass, typeMetadata.capturing);
    }

    public Object[] getParameterValues() {
        return this.paramValues;
    }

    @Override
    public CaptureOfNewInstancesForParameters getCaptureOfNewInstances() {
        return (CaptureOfNewInstancesForParameters)this.captureOfNewInstances;
    }

    public List<Object> getNonStrictMocks() {
        return this.nonStrictMocks;
    }
}

