/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.external.asm.Label;
import mockit.external.asm.MethodAdapter;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;
import mockit.external.asm.commons.GeneratorAdapter;
import mockit.internal.BaseClassModifier;
import mockit.internal.expectations.mocking.MockConstructorInfo;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.startup.Startup;
import mockit.internal.util.SuperConstructorCollector;

final class ExpectationsModifier
extends BaseClassModifier {
    private static final int METHOD_ACCESS_MASK = 5120;
    private static final Type VOID_TYPE = Type.getType("Ljava/lang/Void;");
    private static final Map<String, String> DEFAULT_FILTERS = new HashMap<String, String>(){
        {
            this.put("java/lang/System", "arraycopy getSecurityManager");
            this.put("java/util/AbstractCollection", "<init>");
            this.put("java/util/AbstractList", "<init> iterator");
            this.put("java/util/ArrayList", "get size RangeCheck");
            this.put("java/util/Hashtable", "get");
            this.put("java/lang/Throwable", "<init> fillInStackTrace");
            this.put("java/lang/Exception", "<init>");
        }
    };
    private final MockingConfiguration mockingCfg;
    private final MockConstructorInfo mockConstructorInfo;
    private final boolean ignoreStaticMethods;
    private String redefinedConstructorDesc;
    private String superClassName;
    private String className;
    private String baseClassNameForCapturedInstanceMethods;
    private boolean enableExecutionOfRealImplementation;
    private boolean isProxy;
    private String defaultFilters;

    ExpectationsModifier(ClassLoader classLoader, ClassReader classReader, MockingConfiguration mockingConfiguration, MockConstructorInfo mockConstructorInfo) {
        super(classReader);
        this.mockingCfg = mockingConfiguration;
        this.mockConstructorInfo = mockConstructorInfo;
        this.ignoreStaticMethods = false;
        this.setUseMockingBridge(classLoader);
    }

    ExpectationsModifier(ClassLoader classLoader, ClassReader classReader) {
        super(classReader);
        this.mockingCfg = null;
        this.mockConstructorInfo = null;
        this.ignoreStaticMethods = true;
        this.setUseMockingBridge(classLoader);
    }

    public void setClassNameForInstanceMethods(String internalClassName) {
        this.baseClassNameForCapturedInstanceMethods = internalClassName;
    }

    public void enableExecutionOfRealImplementation() {
        this.enableExecutionOfRealImplementation = true;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superClassName = superName;
        if (this.mockingCfg != null) {
            this.mockingCfg.setSuperClassName(superName);
        }
        super.visit(version, access, name, signature, superName, interfaces);
        this.isProxy = "java/lang/reflect/Proxy".equals(superName);
        if (this.isProxy) {
            this.className = interfaces[0];
            this.defaultFilters = null;
        } else {
            this.className = name;
            this.defaultFilters = DEFAULT_FILTERS.get(name);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean matchesFilters;
        if ((access & 0x1400) != 0 || this.isProxy && this.isConstructorOrSystemMethodNotToBeMocked(name, desc) || this.isMethodOrConstructorNotToBeMocked(access, name)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        boolean noFiltersToMatch = this.mockingCfg == null || this.mockingCfg.isEmpty();
        boolean bl = matchesFilters = noFiltersToMatch || this.mockingCfg.matchesFilters(name, desc);
        if ("<clinit>".equals(name) && matchesFilters) {
            this.mw = super.visitMethod(access, name, desc, signature, exceptions);
            this.generateEmptyImplementation();
            return null;
        }
        if (!matchesFilters || noFiltersToMatch && this.isMethodFromObject(name, desc)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        this.validateModificationOfNativeMethod(access, name);
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        boolean visitingConstructor = "<init>".equals(name);
        if (visitingConstructor && this.superClassName != null) {
            this.redefinedConstructorDesc = desc;
            this.generateCallToDefaultOrConfiguredSuperConstructor();
        }
        String internalClassName = this.className;
        if (this.baseClassNameForCapturedInstanceMethods != null && !visitingConstructor) {
            internalClassName = this.baseClassNameForCapturedInstanceMethods;
        }
        if (this.useMockingBridge) {
            return this.generateCallToHandlerThroughMockingBridge(access, name, desc, internalClassName);
        }
        this.generateDirectCallToHandler(internalClassName, access, name, desc, this.enableExecutionOfRealImplementation);
        if (this.enableExecutionOfRealImplementation) {
            this.generateDecisionBetweenReturningOrContinuingToRealImplementation(desc);
            return visitingConstructor ? new DynamicConstructorModifier() : new MethodAdapter(this.mw);
        }
        this.generateReturnWithObjectAtTopOfTheStack(desc);
        this.mw.visitMaxs(1, 0);
        return null;
    }

    private boolean isConstructorOrSystemMethodNotToBeMocked(String name, String desc) {
        return "<init>".equals(name) || this.isMethodFromObject(name, desc) || "annotationType".equals(name) && "()Ljava/lang/Class;".equals(desc);
    }

    private boolean isMethodOrConstructorNotToBeMocked(int access, String name) {
        return this.isMethodFromCapturedClassNotToBeMocked(access) || this.isStaticMethodToBeIgnored(access) || this.defaultFilters != null && this.defaultFilters.contains(name);
    }

    private boolean isMethodFromCapturedClassNotToBeMocked(int access) {
        return this.baseClassNameForCapturedInstanceMethods != null && (Modifier.isStatic(access) || Modifier.isPrivate(access));
    }

    private boolean isStaticMethodToBeIgnored(int access) {
        return this.ignoreStaticMethods && Modifier.isStatic(access);
    }

    private void validateModificationOfNativeMethod(int access, String name) {
        if (Modifier.isNative(access) && !Startup.isJava6OrLater()) {
            throw new IllegalArgumentException("Mocking of native methods not supported under JDK 1.5; please filter out method \"" + name + "\", or run under JDK 1.6+");
        }
    }

    private void generateCallToDefaultOrConfiguredSuperConstructor() {
        String constructorDesc;
        this.mw.visitVarInsn(25, 0);
        if (this.mockConstructorInfo != null && this.mockConstructorInfo.isWithSuperConstructor()) {
            constructorDesc = this.generateCallToSuperConstructorUsingTestProvidedArguments();
        } else if ("java/lang/Object".equals(this.superClassName)) {
            constructorDesc = "()V";
        } else if (this.mockingCfg != null) {
            Type[] paramTypes = this.mockingCfg.getSuperConstructorParameterTypes();
            constructorDesc = this.generateSuperConstructorArguments(paramTypes);
        } else {
            constructorDesc = new SuperConstructorCollector(1).findConstructor(this.superClassName);
            this.pushDefaultValuesForParameterTypes(constructorDesc);
        }
        this.mw.visitMethodInsn(183, this.superClassName, "<init>", constructorDesc);
    }

    private String generateCallToSuperConstructorUsingTestProvidedArguments() {
        Type[] paramTypes = this.mockConstructorInfo.getParameterTypesForSuperConstructor();
        Object[] args = this.mockConstructorInfo.getSuperConstructorArguments();
        String constructorDesc = Type.getMethodDescriptor(Type.VOID_TYPE, paramTypes);
        GeneratorAdapter generator = new GeneratorAdapter(this.mw, 0, constructorDesc);
        int i = 0;
        for (Type paramType : paramTypes) {
            Object arg = args[i++];
            this.pushParameterValueForSuperConstructorCall(paramType, arg, generator);
        }
        return constructorDesc;
    }

    private void pushParameterValueForSuperConstructorCall(Type paramType, Object arg, GeneratorAdapter generator) {
        switch (paramType.getSort()) {
            case 1: {
                generator.push((Boolean)arg);
                break;
            }
            case 2: {
                generator.push(((Character)arg).charValue());
                break;
            }
            case 3: {
                generator.push(((Byte)arg).byteValue());
                break;
            }
            case 4: {
                generator.push(((Short)arg).shortValue());
                break;
            }
            case 5: {
                generator.push((Integer)arg);
                break;
            }
            case 7: {
                generator.push((Long)arg);
                break;
            }
            case 6: {
                generator.push(((Float)arg).floatValue());
                break;
            }
            case 8: {
                generator.push((Double)arg);
                break;
            }
            default: {
                this.pushObjectValueForSuperConstructorCall(paramType, arg, generator);
            }
        }
    }

    private void pushObjectValueForSuperConstructorCall(Type paramType, Object value, GeneratorAdapter generator) {
        if (value == null || value instanceof String) {
            generator.push((String)value);
        } else if (value instanceof Class) {
            generator.push(paramType);
        } else {
            this.mw.visitInsn(1);
        }
    }

    private MethodVisitor generateCallToHandlerThroughMockingBridge(int access, String name, String desc, String internalClassName) {
        this.generateCallToMockingBridge(1, internalClassName, access, name, desc, this.enableExecutionOfRealImplementation ? 1 : 0);
        this.generateDecisionBetweenReturningOrContinuingToRealImplementation(desc);
        if (Modifier.isNative(access)) {
            this.generateEmptyImplementation(desc);
            return null;
        }
        return new MethodAdapter(this.mw);
    }

    private void generateDecisionBetweenReturningOrContinuingToRealImplementation(String desc) {
        this.mw.visitInsn(89);
        this.mw.visitLdcInsn(VOID_TYPE);
        Label startOfRealImplementation = new Label();
        this.mw.visitJumpInsn(165, startOfRealImplementation);
        this.generateReturnWithObjectAtTopOfTheStack(desc);
        this.mw.visitLabel(startOfRealImplementation);
        this.mw.visitInsn(87);
    }

    String getRedefinedConstructorDesc() {
        return this.redefinedConstructorDesc;
    }

    private final class DynamicConstructorModifier
    extends MethodAdapter {
        DynamicConstructorModifier() {
            super(ExpectationsModifier.this.mw);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 183 && (owner.equals(ExpectationsModifier.this.superClassName) || owner.equals(ExpectationsModifier.this.className))) {
                return;
            }
            ExpectationsModifier.this.mw.visitMethodInsn(opcode, owner, name, desc);
        }
    }
}

