/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.util.HashMap;
import java.util.Map;
import mockit.internal.expectations.mocking.CascadingTypeRedefinition;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class MockedTypeCascade {
    private final Map<String, Object> cascadedTypesAndMocks = new HashMap<String, Object>(4);

    static Object getMock(String mockedTypeDesc, Object mockInstance, String returnTypeDesc) {
        String returnTypeName = MockedTypeCascade.getReturnTypeNameIfCascadingSupportedForIt(returnTypeDesc);
        if (returnTypeName == null) {
            return null;
        }
        MockedTypeCascade cascade = TestRun.getExecutingTest().getMockedTypeCascade(mockedTypeDesc, mockInstance);
        return cascade == null ? null : cascade.getCascadedMock(returnTypeName);
    }

    private static String getReturnTypeNameIfCascadingSupportedForIt(String typeDesc) {
        String typeName = typeDesc.substring(1, typeDesc.length() - 1);
        if (typeName.startsWith("java/lang/") && !typeName.contains("/Process")) {
            return null;
        }
        return typeName;
    }

    private Object getCascadedMock(String returnTypeName) {
        Object mock = this.cascadedTypesAndMocks.get(returnTypeName);
        if (mock == null) {
            Class returnType = Utilities.loadClass(returnTypeName.replace('/', '.'));
            mock = TestRun.mockFixture().getNewInstanceForMockedType(returnType);
            if (mock == null) {
                mock = new CascadingTypeRedefinition(returnType).redefineType();
            }
            this.cascadedTypesAndMocks.put(returnTypeName, mock);
            TestRun.getExecutingTest().addCascadingType(returnTypeName);
        } else {
            mock = TestRun.mockFixture().getNewInstanceForMockedType(mock.getClass());
        }
        return mock;
    }
}

