/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Method;
import mockit.Invocation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.invocation.DelegateInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationResult;
import mockit.internal.util.Utilities;

abstract class DynamicInvocationResult
extends InvocationResult {
    final Object targetObject;
    Method methodToInvoke;
    int numberOfRegularParameters;
    private boolean hasInvocationParameter;

    DynamicInvocationResult(Object targetObject, Method methodToInvoke) {
        this.targetObject = targetObject;
        this.methodToInvoke = methodToInvoke;
        if (methodToInvoke != null) {
            this.determineWhetherMethodToInvokeHasInvocationParameter();
        }
    }

    final void determineWhetherMethodToInvokeHasInvocationParameter() {
        Class<?>[] parameters = this.methodToInvoke.getParameterTypes();
        int n = parameters.length;
        this.hasInvocationParameter = n > 0 && parameters[0] == Invocation.class;
        this.numberOfRegularParameters = this.hasInvocationParameter ? n - 1 : n;
    }

    final Object invokeMethodOnTargetObject(Object mockOrRealObject, InvocationConstraints constraints, Object[] args) {
        Object result = this.hasInvocationParameter ? this.invokeMethodWithContext(mockOrRealObject, constraints, args) : this.executeMethodToInvoke(args);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethodWithContext(Object mockOrRealObject, InvocationConstraints constraints, Object[] args) {
        DelegateInvocation invocation = new DelegateInvocation(mockOrRealObject, constraints.invocationCount, constraints.minInvocations, constraints.maxInvocations);
        Object[] delegateArgs = this.getArgumentsWithExtraInvocationObject(invocation, args);
        try {
            Object object = this.executeMethodToInvoke(delegateArgs);
            return object;
        }
        finally {
            constraints.setLimits(invocation.getMinInvocations(), invocation.getMaxInvocations());
        }
    }

    private Object[] getArgumentsWithExtraInvocationObject(Invocation invocation, Object[] args) {
        Object[] delegateArgs = new Object[args.length + 1];
        delegateArgs[0] = invocation;
        System.arraycopy(args, 0, delegateArgs, 1, args.length);
        return delegateArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeMethodToInvoke(Object[] args) {
        if (!RecordAndReplayExecution.LOCK.isHeldByCurrentThread()) {
            return Utilities.invoke(this.targetObject, this.methodToInvoke, args);
        }
        RecordAndReplayExecution.LOCK.unlock();
        try {
            Object t = Utilities.invoke(this.targetObject, this.methodToInvoke, args);
            return t;
        }
        finally {
            RecordAndReplayExecution.LOCK.lock();
        }
    }
}

