/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationHandler;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VerificationPhase
extends TestOnlyPhase {
    final List<Expectation> expectationsInReplayOrder;
    protected final List<Expectation> expectationsVerified;
    private boolean allInvocationsDuringReplayMustBeVerified;
    private Object[] mockedTypesAndInstancesToFullyVerify;
    protected AssertionError pendingError;

    protected VerificationPhase(RecordAndReplayExecution recordAndReplay, List<Expectation> expectationsInReplayOrder) {
        super(recordAndReplay);
        this.expectationsInReplayOrder = expectationsInReplayOrder;
        this.expectationsVerified = new ArrayList<Expectation>();
    }

    public final void setAllInvocationsMustBeVerified() {
        this.allInvocationsDuringReplayMustBeVerified = true;
    }

    public final void setMockedTypesToFullyVerify(Object[] mockedTypesAndInstancesToFullyVerify) {
        this.mockedTypesAndInstancesToFullyVerify = mockedTypesAndInstancesToFullyVerify;
    }

    @Override
    final Object handleInvocation(Object mock, int mockAccess, String mockClassDesc, String mockNameAndDesc, boolean withRealImpl, Object[] args) {
        if (this.pendingError != null) {
            this.recordAndReplay.setErrorThrown(this.pendingError);
            this.pendingError = null;
            return null;
        }
        this.matchInstance = this.nextInstanceToMatch != null && mock == this.nextInstanceToMatch;
        this.currentExpectation = null;
        this.findNonStrictExpectation(mock, mockClassDesc, mockNameAndDesc, args);
        this.argMatchers = null;
        if (this.matchInstance) {
            this.nextInstanceToMatch = null;
        }
        if (this.recordAndReplay.getErrorThrown() != null) {
            return null;
        }
        if (this.currentExpectation == null) {
            ExpectedInvocation currentInvocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, false, args);
            this.currentExpectation = new Expectation(null, currentInvocation, true);
            ExpectedInvocation missingInvocation = new ExpectedInvocation(mock, mockClassDesc, mockNameAndDesc, args);
            this.pendingError = missingInvocation.errorForMissingInvocation();
        }
        return this.currentExpectation.invocation.getDefaultValueForReturnType(this);
    }

    abstract void findNonStrictExpectation(Object var1, String var2, String var3, Object[] var4);

    final boolean matches(Object mock, String mockClassDesc, String mockNameAndDesc, Object[] args, Expectation expectation) {
        ExpectedInvocation invocation = expectation.invocation;
        Map<Object, Object> instanceMap = this.getInstanceMap();
        if (invocation.isMatch(mock, mockClassDesc, mockNameAndDesc, instanceMap) && (!this.matchInstance || invocation.isEquivalentInstance(mock, instanceMap))) {
            Object[] argsToVerify = this.argMatchers == null ? args : invocation.arguments.prepareForVerification(args, this.argMatchers);
            AssertionError error = invocation.arguments.assertMatch(argsToVerify, instanceMap);
            if (this.argMatchers != null) {
                invocation.arguments.setValuesWithNoMatchers(argsToVerify);
            }
            if (error == null) {
                this.expectationsVerified.add(expectation);
                return true;
            }
        }
        return false;
    }

    @Override
    public final void setMaxInvocationCount(int maxInvocations) {
        if (maxInvocations == 0 || this.pendingError == null) {
            super.setMaxInvocationCount(maxInvocations);
        }
    }

    @Override
    public final void setCustomErrorMessage(CharSequence customMessage) {
        Expectation expectation = this.getCurrentExpectation();
        if (this.pendingError == null) {
            expectation.setCustomErrorMessage(customMessage);
        } else if (customMessage != null) {
            StackTraceElement[] previousStackTrace = ((Throwable)((Object)this.pendingError)).getStackTrace();
            this.pendingError = new AssertionError((Object)(customMessage + "\n" + ((Throwable)((Object)this.pendingError)).getMessage()));
            ((Throwable)((Object)this.pendingError)).setStackTrace(previousStackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean evaluateInvocationHandlerIfExpectationMatchesCurrent(Expectation expectation, InvocationHandler handler, int invocationIndex) {
        ExpectedInvocation invocation = expectation.invocation;
        Object mock = invocation.instance;
        String mockClassDesc = invocation.getClassDesc();
        String mockNameAndDesc = invocation.getMethodNameAndDescription();
        Object[] args = invocation.getArgumentValues();
        InvocationConstraints constraints = expectation.constraints;
        if (this.matches(mock, mockClassDesc, mockNameAndDesc, args, this.currentExpectation)) {
            int originalCount = constraints.invocationCount;
            constraints.invocationCount = invocationIndex + 1;
            try {
                handler.evaluateInvocation(expectation);
            }
            finally {
                constraints.invocationCount = originalCount;
            }
            return true;
        }
        return false;
    }

    protected AssertionError endVerification() {
        if (this.pendingError != null) {
            return this.pendingError;
        }
        if (this.allInvocationsDuringReplayMustBeVerified) {
            return this.validateThatAllInvocationsWereVerified();
        }
        return null;
    }

    private AssertionError validateThatAllInvocationsWereVerified() {
        ArrayList<Expectation> notVerified = new ArrayList<Expectation>(this.expectationsInReplayOrder);
        notVerified.removeAll(this.expectationsVerified);
        this.discardExpectationsThatWillBeVerifiedImplicitly(notVerified);
        if (!notVerified.isEmpty()) {
            if (this.mockedTypesAndInstancesToFullyVerify == null) {
                Expectation firstUnexpected = (Expectation)notVerified.get(0);
                return firstUnexpected.invocation.errorForUnexpectedInvocation();
            }
            return this.validateThatUnverifiedInvocationsAreAllowed(notVerified);
        }
        return null;
    }

    private void discardExpectationsThatWillBeVerifiedImplicitly(List<Expectation> unverified) {
        Iterator<Expectation> itr = unverified.iterator();
        while (itr.hasNext()) {
            Expectation expectation = itr.next();
            if (expectation.constraints.minInvocations <= 0) continue;
            itr.remove();
        }
    }

    private AssertionError validateThatUnverifiedInvocationsAreAllowed(List<Expectation> unverified) {
        for (Expectation expectation : unverified) {
            ExpectedInvocation invocation = expectation.invocation;
            if (!this.isInvocationToBeVerified(invocation)) continue;
            return invocation.errorForUnexpectedInvocation();
        }
        return null;
    }

    private boolean isInvocationToBeVerified(ExpectedInvocation unverifiedInvocation) {
        String invokedClassName = unverifiedInvocation.getClassName();
        Object invokedInstance = unverifiedInvocation.instance;
        for (Object mockedTypeOrInstance : this.mockedTypesAndInstancesToFullyVerify) {
            Class invokedClass;
            Class mockedType;
            if (!(mockedTypeOrInstance instanceof Class ? invokedClassName.equals((mockedType = (Class)mockedTypeOrInstance).getName()) : (invokedInstance == null ? (invokedClass = Utilities.loadClass(invokedClassName)).isInstance(mockedTypeOrInstance) : (unverifiedInvocation.matchInstance ? mockedTypeOrInstance == invokedInstance : invokedInstance.getClass().isInstance(mockedTypeOrInstance))))) continue;
            return true;
        }
        return false;
    }
}

