/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.Phase;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.RecordPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.state.TestRun;

final class ReplayPhase
extends Phase {
    private int initialStrictExpectationIndexForCurrentBlock;
    int currentStrictExpectationIndex;
    final List<Expectation> nonStrictInvocations = new ArrayList<Expectation>();
    private Expectation nonStrictExpectation;

    ReplayPhase(RecordAndReplayExecution recordAndReplay) {
        super(recordAndReplay);
        this.initialStrictExpectationIndexForCurrentBlock = Math.max(recordAndReplay.lastExpectationIndexInPreviousReplayPhase, 0);
        this.positionOnFirstStrictInvocation();
    }

    private void positionOnFirstStrictInvocation() {
        List<Expectation> expectations = this.getExpectations();
        if (expectations.isEmpty()) {
            this.currentStrictExpectationIndex = -1;
            this.currentExpectation = null;
        } else {
            this.currentStrictExpectationIndex = this.initialStrictExpectationIndexForCurrentBlock;
            this.currentExpectation = this.currentStrictExpectationIndex < expectations.size() ? expectations.get(this.currentStrictExpectationIndex) : null;
        }
    }

    Object handleInvocation(Object mock, int mockAccess, String mockClsDesc, String mockDesc, boolean withRealImpl, Object[] args) throws Throwable {
        this.nonStrictExpectation = this.recordAndReplay.executionState.findNonStrictExpectation(mock, mockClsDesc, mockDesc, args);
        if (this.nonStrictExpectation == null) {
            this.createExpectationIfNonStrictInvocation(mock, mockAccess, mockClsDesc, mockDesc, args);
        }
        if (this.nonStrictExpectation != null) {
            this.nonStrictInvocations.add(this.nonStrictExpectation);
            boolean executeRealImpl = withRealImpl && this.nonStrictExpectation.recordPhase == null;
            return this.updateConstraintsAndProduceResult(mock, executeRealImpl, args);
        }
        return this.handleStrictInvocation(mock, mockClsDesc, mockDesc, withRealImpl, args);
    }

    private void createExpectationIfNonStrictInvocation(Object mock, int mockAccess, String mockClassDesc, String mockNameAndDesc, Object[] args) {
        if (!TestRun.getExecutingTest().containsStrictMockForRunningTest(mock, mockClassDesc)) {
            ExpectedInvocation invocation = new ExpectedInvocation(mock, mockAccess, mockClassDesc, mockNameAndDesc, false, args);
            this.nonStrictExpectation = new Expectation(null, invocation, true);
            this.recordAndReplay.executionState.addExpectation(this.nonStrictExpectation, true);
        }
    }

    private Object updateConstraintsAndProduceResult(Object mock, boolean executeRealImpl, Object[] args) throws Throwable {
        this.nonStrictExpectation.constraints.incrementInvocationCount();
        if (executeRealImpl) {
            return Void.class;
        }
        if (this.nonStrictExpectation.constraints.isInvocationCountMoreThanMaximumExpected()) {
            this.recordAndReplay.setErrorThrown(this.nonStrictExpectation.invocation.errorForUnexpectedInvocations(1));
            return null;
        }
        return this.nonStrictExpectation.produceResult(mock, args);
    }

    private Object handleStrictInvocation(Object mock, String mockClassDesc, String mockNameAndDesc, boolean withRealImpl, Object[] replayArgs) throws Throwable {
        ExpectedInvocation invocation;
        Map<Object, Object> instanceMap = this.getInstanceMap();
        while (true) {
            if (this.currentExpectation == null) {
                return this.handleUnexpectedInvocation(mock, mockClassDesc, mockNameAndDesc, withRealImpl, replayArgs);
            }
            invocation = this.currentExpectation.invocation;
            if (invocation.isMatch(mock, mockClassDesc, mockNameAndDesc, instanceMap)) {
                AssertionError error;
                if (mock != invocation.instance) {
                    instanceMap.put(invocation.instance, mock);
                }
                if ((error = invocation.arguments.assertMatch(replayArgs, instanceMap)) != null) {
                    if (this.currentExpectation.constraints.isInvocationCountInExpectedRange()) {
                        this.moveToNextExpectation();
                        continue;
                    }
                    if (withRealImpl) {
                        return Void.class;
                    }
                    this.recordAndReplay.setErrorThrown(error);
                    return null;
                }
                Expectation expectation = this.currentExpectation;
                if (expectation.constraints.incrementInvocationCount()) {
                    this.moveToNextExpectation();
                } else if (expectation.constraints.isInvocationCountMoreThanMaximumExpected()) {
                    this.recordAndReplay.setErrorThrown(invocation.errorForUnexpectedInvocations(1));
                    return null;
                }
                return expectation.produceResult(mock, replayArgs);
            }
            if (!this.currentExpectation.constraints.isInvocationCountInExpectedRange()) break;
            this.moveToNextExpectation();
        }
        if (withRealImpl) {
            return Void.class;
        }
        this.recordAndReplay.setErrorThrown(invocation.errorForUnexpectedInvocation(mock, mockClassDesc, mockNameAndDesc));
        return null;
    }

    private Object handleUnexpectedInvocation(Object mock, String mockClassDesc, String mockNameAndDesc, boolean withRealImpl, Object[] replayArgs) {
        if (withRealImpl) {
            return Void.class;
        }
        this.recordAndReplay.setErrorThrown(new ExpectedInvocation(mock, mockClassDesc, mockNameAndDesc, replayArgs).errorForUnexpectedInvocation());
        return null;
    }

    private void moveToNextExpectation() {
        List<Expectation> expectations = this.getExpectations();
        RecordPhase expectationBlock = this.currentExpectation.recordPhase;
        ++this.currentStrictExpectationIndex;
        Expectation expectation = this.currentExpectation = this.currentStrictExpectationIndex < expectations.size() ? expectations.get(this.currentStrictExpectationIndex) : null;
        if (expectationBlock.numberOfIterations == 1) {
            if (this.currentExpectation != null && this.currentExpectation.recordPhase != expectationBlock) {
                this.initialStrictExpectationIndexForCurrentBlock = this.currentStrictExpectationIndex;
            }
        } else if (this.currentExpectation == null || this.currentExpectation.recordPhase != expectationBlock) {
            --expectationBlock.numberOfIterations;
            this.positionOnFirstStrictInvocation();
            this.resetInvocationCountsForStrictExpectations(expectationBlock);
        }
    }

    private void resetInvocationCountsForStrictExpectations(RecordPhase expectationBlock) {
        for (Expectation expectation : this.getExpectations()) {
            if (expectation.recordPhase != expectationBlock) continue;
            expectation.constraints.invocationCount = 0;
        }
    }

    AssertionError endExecution() {
        Expectation strict = this.currentExpectation;
        this.currentExpectation = null;
        if (strict != null && strict.constraints.isInvocationCountLessThanMinimumExpected()) {
            return strict.invocation.errorForMissingInvocation();
        }
        List<Expectation> nonStrictExpectations = this.getNonStrictExpectations();
        for (Expectation nonStrict : nonStrictExpectations) {
            InvocationConstraints constraints = nonStrict.constraints;
            if (!constraints.isInvocationCountLessThanMinimumExpected()) continue;
            return constraints.errorForMissingExpectations(nonStrict.invocation);
        }
        return null;
    }
}

