/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PhasedExecutionState {
    final List<Expectation> expectations = new ArrayList<Expectation>();
    final List<Expectation> nonStrictExpectations = new ArrayList<Expectation>();
    final Map<Object, Object> instanceMap = new IdentityHashMap<Object, Object>();
    private List<Class<?>> mockedTypesToMatchOnInstances;

    PhasedExecutionState() {
    }

    void discoverMockedTypesToMatchOnInstances(List<Class<?>> targetClasses) {
        int numClasses = targetClasses.size();
        if (numClasses > 1) {
            for (int i = 0; i < numClasses; ++i) {
                Class<?> targetClass = targetClasses.get(i);
                if (targetClasses.lastIndexOf(targetClass) <= i) continue;
                this.addMockedTypeToMatchOnInstance(targetClass);
            }
        }
    }

    private void addMockedTypeToMatchOnInstance(Class<?> mockedType) {
        if (this.mockedTypesToMatchOnInstances == null) {
            this.mockedTypesToMatchOnInstances = new LinkedList();
        }
        this.mockedTypesToMatchOnInstances.add(mockedType);
    }

    void addExpectation(Expectation expectation, boolean nonStrict) {
        ExpectedInvocation invocation = expectation.invocation;
        this.forceMatchingOnMockInstanceIfRequired(invocation);
        this.removeMatchingExpectationsCreatedBeforeRecordPhase(invocation);
        if (nonStrict) {
            this.nonStrictExpectations.add(expectation);
        } else {
            this.expectations.add(expectation);
        }
    }

    private void forceMatchingOnMockInstanceIfRequired(ExpectedInvocation invocation) {
        Class<?> mockedClass;
        Object mock;
        if (this.mockedTypesToMatchOnInstances != null && (mock = invocation.instance) != null && this.mockedTypesToMatchOnInstances.contains(mockedClass = Utilities.getMockedClass(mock))) {
            invocation.matchInstance = true;
        }
    }

    private void removeMatchingExpectationsCreatedBeforeRecordPhase(ExpectedInvocation invocation) {
        Expectation previousExpectation = this.findNonStrictExpectation(invocation.instance, invocation.getClassDesc(), invocation.getMethodNameAndDescription(), invocation.getArgumentValues());
        if (previousExpectation != null && previousExpectation.recordPhase == null) {
            this.nonStrictExpectations.remove(previousExpectation);
        }
    }

    Expectation findNonStrictExpectation(Object mock, String mockClassDesc, String mockNameAndDesc, Object[] args) {
        int n = this.nonStrictExpectations.size();
        for (int i = 0; i < n; ++i) {
            Expectation nonStrict = this.nonStrictExpectations.get(i);
            ExpectedInvocation invocation = nonStrict.invocation;
            if (!invocation.isMatch(mockClassDesc, mockNameAndDesc) || !invocation.isMatch(mock, this.instanceMap) || invocation.arguments.assertMatch(args, this.instanceMap) != null) continue;
            return nonStrict;
        }
        return null;
    }

    void makeNonStrict(Expectation expectation) {
        if (this.expectations.remove(expectation)) {
            expectation.constraints.setDefaultLimits(true);
            this.nonStrictExpectations.add(expectation);
        }
    }
}

