/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.List;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.VerificationPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderedVerificationPhase
extends VerificationPhase {
    private final int expectationCount;
    private boolean unverifiedExpectationsLeftBehind;
    private boolean unverifiedExpectationsFixed;
    private int replayIndex;
    private int indexIncrement;

    OrderedVerificationPhase(RecordAndReplayExecution recordAndReplay, List<Expectation> expectationsInReplayOrder) {
        super(recordAndReplay, expectationsInReplayOrder);
        this.expectationCount = expectationsInReplayOrder.size();
        this.indexIncrement = 1;
    }

    @Override
    protected void findNonStrictExpectation(Object mock, String mockClassDesc, String mockNameAndDesc, Object[] args) {
        for (int i = this.replayIndex; i >= 0 && i < this.expectationCount; i += this.indexIncrement) {
            Expectation expectation = (Expectation)this.expectationsInReplayOrder.get(i);
            if (this.matches(mock, mockClassDesc, mockNameAndDesc, args, expectation)) {
                this.currentExpectation = expectation;
                i += 1 - this.indexIncrement;
                this.indexIncrement = 1;
                if (this.argMatchers != null) {
                    expectation.invocation.arguments.setMatchers(this.argMatchers);
                }
                this.replayIndex = i;
                break;
            }
            if (this.unverifiedExpectationsFixed) continue;
            this.unverifiedExpectationsLeftBehind = true;
        }
    }

    public void fixPositionOfUnverifiedExpectations() {
        if (this.unverifiedExpectationsLeftBehind) {
            throw new AssertionError((Object)("Unexpected invocations before" + this.currentExpectation.invocation));
        }
        if (this.replayIndex >= this.expectationCount) {
            throw new AssertionError((Object)"No unverified invocations left");
        }
        this.replayIndex = this.expectationCount - 1;
        this.indexIncrement = -1;
        this.unverifiedExpectationsFixed = true;
    }

    @Override
    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        Expectation nextExpectation;
        ExpectedInvocation invocation = this.currentExpectation.invocation;
        Object mock = invocation.instance;
        String mockClassDesc = invocation.getClassDesc();
        String mockNameAndDesc = invocation.getMethodNameAndDescription();
        Object[] args = invocation.arguments.getValues();
        this.argMatchers = invocation.arguments.getMatchers();
        int invocationCount = 1;
        while (this.replayIndex < this.expectationCount && this.matches(mock, mockClassDesc, mockNameAndDesc, args, nextExpectation = (Expectation)this.expectationsInReplayOrder.get(this.replayIndex))) {
            if (++invocationCount > maxInvocations) {
                if (maxInvocations < 0 || this.numberOfIterations != 1) break;
                this.pendingError = nextExpectation.invocation.errorForUnexpectedInvocation();
                return;
            }
            ++this.replayIndex;
        }
        this.argMatchers = null;
        int n = minInvocations - invocationCount;
        if (n > 0) {
            this.pendingError = invocation.errorForMissingInvocations(n);
            return;
        }
        if (maxInvocations >= 0 && (n = this.currentExpectation.constraints.invocationCount - maxInvocations * this.numberOfIterations) > 0) {
            this.pendingError = invocation.errorForUnexpectedInvocations(n);
            return;
        }
        this.pendingError = null;
    }

    @Override
    public void applyHandlerForEachInvocation(Object invocationHandler) {
        Expectation expectation;
        if (this.pendingError != null) {
            return;
        }
        this.getCurrentExpectation();
        InvocationHandler handler = new InvocationHandler(invocationHandler);
        for (int i = this.expectationsInReplayOrder.indexOf(this.currentExpectation); i < this.expectationCount && this.evaluateInvocationHandlerIfExpectationMatchesCurrent(expectation = (Expectation)this.expectationsInReplayOrder.get(i), handler, i); ++i) {
        }
    }

    @Override
    protected AssertionError endVerification() {
        if (this.pendingError != null) {
            return this.pendingError;
        }
        if (this.unverifiedExpectationsFixed && this.indexIncrement > 0 && this.replayIndex < this.expectationCount && this.currentExpectation != null) {
            return new AssertionError((Object)("Unexpected invocations after" + this.currentExpectation.invocation));
        }
        AssertionError error = this.verifyMultipleIterations();
        if (error != null) {
            return error;
        }
        return super.endVerification();
    }

    private AssertionError verifyMultipleIterations() {
        int n = this.expectationsVerified.size();
        for (int i = 1; i < this.numberOfIterations; ++i) {
            AssertionError error = this.verifyNextIterationOfWholeBlockOfInvocations(n);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private AssertionError verifyNextIterationOfWholeBlockOfInvocations(int n) {
        for (int i = 0; i < n; ++i) {
            Expectation verified = (Expectation)this.expectationsVerified.get(i);
            ExpectedInvocation invocation = verified.invocation;
            this.argMatchers = invocation.arguments.getMatchers();
            this.handleInvocation(invocation.instance, 0, invocation.getClassDesc(), invocation.getMethodNameAndDescription(), false, invocation.arguments.getValues());
            AssertionError testFailure = this.recordAndReplay.getErrorThrown();
            if (testFailure == null) continue;
            return testFailure;
        }
        return null;
    }
}

